/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.sql;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOAbility;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOSkill;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOStage;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.rest.entities.common.BaseRestEntity;
import com.radiantminds.roadmap.common.rest.entities.common.BaseRestRankableDescribable;
import com.radiantminds.roadmap.common.rest.entities.skills.RestSkill;
import com.radiantminds.roadmap.common.rest.entities.skills.RestStage;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class StageSQL
extends BaseAOPersistenceSQL {
    public StageSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public void deleteAllStageAbilities(final String stageId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOAbility.class, "t").deleteFrom().tableNoAlias("t").where().colNoAlias("t", "targetType").eq().str("stage").and().colNoAlias("t", "targetId").eq().numeric(stageId);
            }
        });
    }

    public List<IStage> getStages(final String planId) throws SQLException {
        return this.sql(new IQuery<List<IStage>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOStage.class, "stage").withTable(AOSkill.class, "skill").select().col("stage", "ID_OTHER", false).col("stage", "version").col("stage", "title").col("stage", "details").col("stage", "color").col("stage", "percentage").col("stage", "sortOrder").col("skill", "ID_OTHER", false).col("skill", "version").col("skill", "title").col("skill", "details").col("skill", "percentage").col("skill", "sortOrder").from("stage").leftJoin().table("skill").on().col("skill", "aostage").eq().col("stage", "ID_OTHER", false).where().col("stage", "aoplan").eq().numeric(planId).orderBy().col("stage", "sortOrder").col("skill", "sortOrder");
            }

            @Override
            public List<IStage> handleResult(ResultSet result) throws Exception {
                ArrayList stages = Lists.newArrayList();
                BaseRestEntity stage = null;
                while (result.next()) {
                    String description;
                    String title;
                    Long version;
                    String stageId = BaseAOPersistenceSQL.getString(result, 1);
                    String skillId = BaseAOPersistenceSQL.getString(result, 8);
                    if (stage == null || !stageId.equals(stage.getId())) {
                        version = StageSQL.getLong(result, 2);
                        title = BaseAOPersistenceSQL.getString(result, 3);
                        description = BaseAOPersistenceSQL.getString(result, 4);
                        String color = BaseAOPersistenceSQL.getString(result, 5);
                        Double percentage = BaseAOPersistenceSQL.getDouble(result, 6);
                        Long sortOrder = StageSQL.getLong(result, 7);
                        stage = new RestStage(stageId, title, description, color, Lists.newArrayList());
                        stage.setVersion(version);
                        ((RestStage)stage).setPercentage(percentage);
                        ((BaseRestRankableDescribable)stage).setSortOrder(sortOrder);
                        stages.add(stage);
                    }
                    if (skillId == null) continue;
                    version = StageSQL.getLong(result, 9);
                    title = BaseAOPersistenceSQL.getString(result, 10);
                    description = BaseAOPersistenceSQL.getString(result, 11);
                    Double percentage = BaseAOPersistenceSQL.getDouble(result, 12);
                    Long sortOrder = StageSQL.getLong(result, 13);
                    RestSkill skill = new RestSkill(skillId, title, description);
                    skill.setVersion(version);
                    skill.setPercentage(percentage);
                    skill.setSortOrder(sortOrder);
                    skill.setStage((IStage)((Object)stage));
                    ((RestStage)stage).addRestSkill(skill);
                }
                return stages;
            }
        });
    }
}

