/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem;

import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemType;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.SortOrderUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.NewTreeAdaptionResult;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.VersionedId;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.WorkItemInheritanceOperator;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.WorkItemMoveResultImpl;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.WorkItemMoveResult;
import com.radiantminds.roadmap.common.extensions.issues.IssueSyncData;
import com.radiantminds.roadmap.common.extensions.issues.PortfolioToJiraSyncExtension;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtils;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import java.sql.SQLException;
import java.util.Set;
import javax.annotation.Nullable;

class WorkItemMoveOperator {
    private final PortfolioWorkItemPersistence persistence;
    private final SubCollectionUtils subCollectionUtils;
    private final SortOrderUtils sortOrderUtils;
    private final WorkItemInheritanceOperator inheritanceOperator;
    private PortfolioToJiraSyncExtension portfolioToJiraSyncExtension;

    WorkItemMoveOperator(PortfolioWorkItemPersistence persistence, SubCollectionUtils subCollectionUtils, SortOrderUtils sortOrderUtils, WorkItemInheritanceOperator inheritanceOperator, PortfolioToJiraSyncExtension portfolioToJiraSyncExtension) {
        this.persistence = persistence;
        this.subCollectionUtils = subCollectionUtils;
        this.sortOrderUtils = sortOrderUtils;
        this.inheritanceOperator = inheritanceOperator;
        this.portfolioToJiraSyncExtension = portfolioToJiraSyncExtension;
    }

    WorkItemMoveOperator(PortfolioWorkItemPersistence persistence, ActiveObjectsUtilities aoUtils, WorkItemInheritanceOperator inheritanceOperator, PortfolioToJiraSyncExtension portfolioToJiraSyncExtension) {
        this(persistence, new SubCollectionUtils(aoUtils, persistence), new SortOrderUtils(aoUtils), inheritanceOperator, portfolioToJiraSyncExtension);
    }

    public WorkItemMoveResult moveWorkItem(IWorkItem workItem, @Nullable String newParentDbId, @Nullable RestRank rank, @Nullable Set<String> restrictedInheritance) throws Exception {
        Preconditions.checkNotNull((Object)workItem, (Object)"work item must not be null");
        String oldParentDbId = (String)this.getDbId(workItem.getParentId()).orNull();
        this.adaptSortOrderForStoryMove(workItem, newParentDbId, oldParentDbId);
        NewTreeAdaptionResult newParentAdaptionResult = this.adaptNewTree(workItem, newParentDbId, restrictedInheritance);
        if (this.unstructureItem(oldParentDbId)) {
            this.persistence.inheritStreamsUpwards(workItem.getId());
        }
        this.persistence.setParent(workItem.getId(), newParentDbId);
        this.subCollectionUtils.tryRanking(newParentDbId, workItem.getId(), rank);
        return new WorkItemMoveResultImpl(this.updateVersion(workItem.getId()), this.updateVersion(newParentDbId), this.updateVersion(oldParentDbId), newParentAdaptionResult);
    }

    private VersionedId updateVersion(@Nullable String id) throws SQLException {
        if (id == null) {
            return new VersionedId("-1", null);
        }
        return new VersionedId(id, this.persistence.incrementVersion(id));
    }

    private NewTreeAdaptionResult adaptNewTree(IWorkItem workItem, String newParentDbId, Set<String> restrictedInheritance) throws SQLException, PersistenceException {
        if (this.structureItem(newParentDbId)) {
            Optional<String> themeId = this.persistence.clearPropertiesOfWorkItem(newParentDbId);
            if (themeId.isPresent()) {
                Set<IWorkItem> inheritingItems = this.inheritanceOperator.tryInheritTheme((String)themeId.get(), workItem, restrictedInheritance);
                Set<String> inheritedIds = RmIdentifiableUtils.getIds(inheritingItems);
                return new NewTreeAdaptionResult((String)themeId.get(), inheritedIds);
            }
            this.portfolioToJiraSyncExtension.syncWorkItemToIssues(IssueSyncData.createEstimateSyncFor(newParentDbId));
        }
        return NewTreeAdaptionResult.noAdaptions;
    }

    private void adaptSortOrderForStoryMove(IWorkItem workItem, @Nullable String newParentDbId, @Nullable String oldParentDbId) throws SQLException, PersistenceException {
        if (!WorkItemType.Story.equals((Object)workItem.getWorkItemType())) {
            return;
        }
        if (this.structureItem(newParentDbId)) {
            this.sortOrderUtils.clearAndAdaptSortOrder(workItem.getId(), AOWorkItem.class);
            long sortOrderOfNewParent = ((IWorkItem)this.persistence.get(newParentDbId)).getSortOrder();
            this.sortOrderUtils.clearSortOrderDontCascade(newParentDbId, AOWorkItem.class);
            this.sortOrderUtils.setSortOrder(workItem.getId(), AOWorkItem.class, sortOrderOfNewParent, workItem.getOrderRangeIdentifier());
            if (this.unstructureItem(oldParentDbId)) {
                this.sortOrderUtils.shiftAll(workItem.getOrderRangeIdentifier(), workItem.getSortOrder(), AOWorkItem.class);
            }
        }
        if (this.unstructureItem(oldParentDbId)) {
            this.sortOrderUtils.setSortOrder(oldParentDbId, AOWorkItem.class, workItem.getSortOrder(), workItem.getOrderRangeIdentifier());
        }
    }

    private Optional<String> getDbId(String id) {
        if ("-1".equals(id)) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)id);
    }

    private boolean structureItem(String newParentDbId) throws SQLException {
        return newParentDbId != null && this.persistence.countChildren(newParentDbId) == 0;
    }

    private boolean unstructureItem(String oldParentId) throws SQLException {
        return oldParentId != null && this.persistence.countChildren(oldParentId) == 1;
    }
}

