/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import java.sql.ResultSet;
import java.sql.SQLException;

public class WorkItemCountSQL
extends BaseAOPersistenceSQL {
    public WorkItemCountSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public Long countAllForPlan(final String planId) throws SQLException {
        return this.sql(new IQuery<Long>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").select().raw("COUNT(*)").from("w").where().col("w", "aoPlan").eq().numeric(planId);
            }

            @Override
            public Long handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return WorkItemCountSQL.getLong(result, 1);
                }
                return 0L;
            }
        });
    }
}

