/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOSprint;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.replanning.AOReplanning;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkItemRelationSQL
extends BaseAOPersistenceSQL {
    public WorkItemRelationSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public String getReplanningRelationTargetId(final String targetType, final String workItemId) throws SQLException {
        return this.sql(new IQuery<String>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOReplanning.class, "r").select().col("r", "targetId").from("r").where().col("r", "targetType").eq().str(targetType).and().col("r", "workItem").eq().numeric(workItemId);
            }

            @Override
            public String handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getString(result, 1);
                }
                return null;
            }
        });
    }

    public Map<String, Optional<String>> getReplanningRelationTargets(final String workItemId) throws SQLException {
        return this.sql(new IQuery<Map<String, Optional<String>>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOReplanning.class, "r").select().distinct().col("r", "targetType").col("r", "targetId").from("r").where().col("r", "workItem").eq().numeric(workItemId);
            }

            @Override
            public Map<String, Optional<String>> handleResult(ResultSet result) throws Exception {
                HashMap targets = Maps.newHashMap();
                while (result.next()) {
                    targets.put(BaseAOPersistenceSQL.getString(result, 1), Optional.fromNullable((Object)BaseAOPersistenceSQL.getString(result, 2)));
                }
                return targets;
            }
        });
    }

    public String getReplanningRelationId(final String targetType, final String workItemId) throws SQLException {
        return this.sql(new IQuery<String>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOReplanning.class, "r").select().colId("r").from("r").where().col("r", "targetType").eq().str(targetType).and().col("r", "workItem").eq().numeric(workItemId);
            }

            @Override
            public String handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getString(result, 1);
                }
                return null;
            }
        });
    }

    public List<String> getReplanningRelationWorkItemIds(final String targetType, final List<String> workItemIds) throws SQLException {
        if (workItemIds.isEmpty()) {
            return Lists.newArrayList();
        }
        return this.sql(new IQuery<List<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOReplanning.class, "r").select().col("r", "workItem").from("r").where().col("r", "targetType").eq().str(targetType).and().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.col("r", "workItem");
                    }
                }, workItemIds);
            }

            @Override
            public List<String> handleResult(ResultSet result) throws Exception {
                ArrayList ids = Lists.newArrayList();
                while (result.next()) {
                    ids.add(BaseAOPersistenceSQL.getString(result, 1));
                }
                return ids;
            }
        });
    }

    public void setTeam(final String workItem, final String teamId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").update().tableNoAlias("w").set().colNoAlias("w", "aoTeam").eq().numeric(teamId).where().colIdNoAlias("w").eq().numeric(workItem);
            }
        });
    }

    public Boolean validateSprintAssignment(final String teamId, final String sprintId) throws SQLException {
        if (sprintId == null) {
            return true;
        }
        return this.sql(new IQuery<Boolean>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOSprint.class, "s").select().raw("COUNT(*)").from("s").where().colId("s").eq().numeric(sprintId).and().col("s", "aoTeam").eq().numeric(teamId);
            }

            @Override
            public Boolean handleResult(ResultSet result) throws Exception {
                if (result.next() && BaseAOPersistenceSQL.getInt(result, 1) == 1) {
                    return true;
                }
                return false;
            }
        });
    }

    public void setSprint(final String workItem, final String sprintId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").update().tableNoAlias("w").set().colNoAlias("w", "aoSprint").eq().numeric(sprintId).where().colIdNoAlias("w").eq().numeric(workItem);
            }
        });
    }

    public void clearSprintAssignments(final List<String> sprintIds) throws SQLException {
        if (sprintIds.isEmpty()) {
            return;
        }
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").update().tableNoAlias("w").set().colNoAlias("w", "aoSprint").eq().nullValue().where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colNoAlias("w", "aoSprint");
                    }
                }, sprintIds);
            }
        });
    }

    public void setStream(final String workItem, final String streamId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").update().tableNoAlias("w").set().colNoAlias("w", "aoStream").eq().numeric(streamId).where().colIdNoAlias("w").eq().numeric(workItem);
            }
        });
    }

    public void setRelease(final String workItem, final String realeaseId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").update().tableNoAlias("w").set().colNoAlias("w", "aoRelease").eq().numeric(realeaseId).where().colIdNoAlias("w").eq().numeric(workItem);
            }
        });
    }

    public void deleteAllReplanningRelations(final String workItemId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOReplanning.class, "r").deleteFrom().tableNoAlias("r").where().colNoAlias("r", "workItem").eq().numeric(workItemId);
            }
        });
    }

    public void deleteReplanningRelation(final String workItemId, final String targetType) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOReplanning.class, "r").deleteFrom().tableNoAlias("r").where().colNoAlias("r", "workItem").eq().numeric(workItemId).and().colNoAlias("r", "targetType").eq().str(targetType);
            }
        });
    }

    public void deleteReplanningRelationsForWorkItems(final List<String> workItemIds) throws SQLException {
        if (workItemIds.isEmpty()) {
            return;
        }
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOReplanning.class, "r").deleteFrom().tableNoAlias("r").where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colNoAlias("r", "workItem");
                    }
                }, workItemIds);
            }
        });
    }

    public void deleteReplanningRelations(final List<String> workItemIds, final List<String> targetTypes) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOReplanning.class, "r").deleteFrom().tableNoAlias("r").where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colNoAlias("r", "workItem");
                    }
                }, workItemIds).and().in(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colNoAlias("r", "targetType");
                    }
                }, targetTypes);
            }
        });
    }

    public void deleteReplanningRelationsForTarget(final String targetId, final String targetType) throws SQLException {
        List<String> affectedWorkItems;
        if ("stream".equals(targetType) && (affectedWorkItems = this.sql(new IQuery<List<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOReplanning.class, "r").select().col("r", "workItem").from("r").where().col("r", "targetType").eq().str("stream").and().col("r", "targetId").eq().str(targetId);
            }

            @Override
            public List<String> handleResult(ResultSet result) throws Exception {
                ArrayList retVal = Lists.newArrayList();
                while (result.next()) {
                    retVal.add(BaseAOPersistenceSQL.getString(result, 1));
                }
                return retVal;
            }
        })).size() > 0) {
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOReplanning.class, "rp").deleteFrom().tableNoAlias("rp").where().colNoAlias("rp", "targetType").eq().str("release").and().inNumeric(new AOQueryGenerator.InOperandCallback(){

                        @Override
                        public void generateOperand(AOQueryGenerator generator) {
                            generator.colNoAlias("rp", "workItem");
                        }
                    }, affectedWorkItems);
                }
            });
        }
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOReplanning.class, "r").deleteFrom().tableNoAlias("r").where().colNoAlias("r", "targetId").eq().str(targetId).and().colNoAlias("r", "targetType").eq().str(targetType);
            }
        });
    }

    public void setReplanningRelation(final String workItemId, final String targetType, final String targetId) throws SQLException {
        final String id = this.getReplanningRelationId(targetType, workItemId);
        if (id != null) {
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOReplanning.class, "r").update().tableNoAlias("r").set().colNoAlias("r", "targetId").eq().str(targetId).where().colIdNoAlias("r").eq().numeric(id);
                }
            });
        } else {
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOReplanning.class, "r").insert().tableNoAlias("r").raw("(").colNoAlias("r", "targetId").colNoAlias("r", "targetType").colNoAlias("r", "workItem").raw(") VALUES (").str(targetId).raw(", ").str(targetType).raw(", ").numeric(workItemId).raw(")");
                }
            });
        }
    }

    public void setParent(final String id, final String parent) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").update().tableNoAlias("w").set().colNoAlias("w", "aoParent").eq().numeric(parent).where().colIdNoAlias("w").eq().numeric(id);
            }
        });
    }

    public void setTheme(final String workItem, final String themeId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").update().tableNoAlias("w").set().colNoAlias("w", "aoTheme").eq();
                if (themeId == null) {
                    generator.nullValue();
                } else {
                    generator.numeric(themeId);
                }
                generator.where().colIdNoAlias("w").eq().numeric(workItem);
            }
        });
    }

    public void setStatus(final String workItem, final Integer replanningStatus) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").update().tableNoAlias("w").set().colNoAlias("w", "status").eq().numeric(replanningStatus).where().colIdNoAlias("w").eq().numeric(workItem);
            }
        });
    }

    public void setReplanningStatus(final List<String> workItemIds, final Integer replanningStatus) throws SQLException {
        if (workItemIds.isEmpty()) {
            return;
        }
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").update().tableNoAlias("w").set().colNoAlias("w", "replanningStatus").eq().numeric(replanningStatus).where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colIdNoAlias("w");
                    }
                }, workItemIds);
            }
        });
    }
}

