/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.port.dynamics.handlers;

import com.atlassian.pocketknife.api.logging.Log;
import com.radiantminds.roadmap.common.data.persistence.ao.port.dynamics.DynamicValueHandler;
import com.radiantminds.roadmap.common.extensions.settings.SettingsExtension;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DynamicWorkingDaysHandler
implements DynamicValueHandler {
    private static final Log LOGGER = Log.with(DynamicWorkingDaysHandler.class);
    private static final Pattern PATTERN = Pattern.compile("^\\$JIRAWORKINGDAYS$");
    private final SettingsExtension settingsExtension;

    @Autowired
    public DynamicWorkingDaysHandler(SettingsExtension settingsExtension) {
        this.settingsExtension = settingsExtension;
    }

    @Override
    public Pattern getMatchPattern() {
        return PATTERN;
    }

    @Override
    public String getReplacement(Matcher matcher) {
        long workingDaysCount = 5L;
        try {
            String workingDaysInJira = this.settingsExtension.getWorkingDaysSetting();
            workingDaysCount = Math.round(Double.parseDouble(workingDaysInJira));
            if (workingDaysCount < 1L) {
                workingDaysCount = 1L;
            }
            if (workingDaysCount > 7L) {
                workingDaysCount = 7L;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Unable to extract days per week from Jira.", new Object[0]);
            LOGGER.exception(ex);
        }
        String binaryString = "";
        for (int i = 0; i < 7; ++i) {
            if (workingDaysCount > 0L) {
                binaryString = binaryString + "1";
                --workingDaysCount;
                continue;
            }
            binaryString = binaryString + "0";
        }
        return String.valueOf(Integer.parseInt(binaryString, 2));
    }
}

