/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.port.legacy.modifiers;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlanConfiguration;
import com.radiantminds.roadmap.common.data.persistence.ao.port.AOTableImportData;
import com.radiantminds.roadmap.common.data.persistence.ao.port.legacy.BaseLegacyDocumentModifier;
import com.radiantminds.roadmap.common.utils.JPOVersion;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class SyncSettingsLegacyModifier
extends BaseLegacyDocumentModifier {
    static final String STORYSYNCMODE = "storysyncmode";
    static final String EPICSYNCMODE = "epicsyncmode";
    static final String INITIATIVESYNCMODE = "initiativesyncmode";

    @Override
    public JPOVersion isRelevantBeforeVersion() {
        return new JPOVersion(1, 9, 0);
    }

    @Override
    public void modify(List<AOTableImportData> importData) {
        Optional<AOTableImportData> configData = this.getDataFor(AOPlanConfiguration.class, importData);
        if (!configData.isPresent()) {
            return;
        }
        Map<String, String> config = ((AOTableImportData)configData.get()).getRows().get(0);
        SyncSettingsLegacyModifier.convert(config, STORYSYNCMODE, "syncstories");
        SyncSettingsLegacyModifier.convert(config, EPICSYNCMODE, "syncepics");
        SyncSettingsLegacyModifier.convert(config, INITIATIVESYNCMODE, "syncinitiatives");
    }

    private static void convert(Map<String, String> config, String syncKey, String newSyncKey) {
        if (config.containsKey(syncKey)) {
            boolean syncEnabled = !config.get(syncKey).equals("none");
            config.remove(syncKey);
            if (syncEnabled) {
                config.put(newSyncKey, String.valueOf(true));
            }
        }
    }
}

