/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.sql;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.DefaultAOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.HSQL2AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.HSQLQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.MySQLAOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.OracleAOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.PostgreSQLAOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.SQLServerAOQueryGenerator;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

class AOQueryGeneratorFactory {
    AOQueryGeneratorFactory() {
    }

    public static AOQueryGenerator create(Connection connection, ActiveObjectsUtilities activeObjectsUtilities) throws SQLException {
        DatabaseMetaData meta = connection.getMetaData();
        String databaseType = meta.getDatabaseProductName().toLowerCase();
        if (databaseType.contains("microsoft sql server")) {
            return new SQLServerAOQueryGenerator(connection, activeObjectsUtilities);
        }
        if (databaseType.contains("oracle")) {
            return new OracleAOQueryGenerator(connection, activeObjectsUtilities);
        }
        if (databaseType.contains("mysql")) {
            return new MySQLAOQueryGenerator(connection, activeObjectsUtilities);
        }
        if (databaseType.contains("postgre")) {
            return new PostgreSQLAOQueryGenerator(connection, activeObjectsUtilities);
        }
        if (databaseType.contains("hsql")) {
            if (meta.getDatabaseMajorVersion() >= 2) {
                return new HSQL2AOQueryGenerator(connection, activeObjectsUtilities);
            }
            return new HSQLQueryGenerator(connection, activeObjectsUtilities);
        }
        return new DefaultAOQueryGenerator(connection, activeObjectsUtilities);
    }
}

