/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.extensions.releases;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtensionDataRequest;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ReleasesExtensionDataBulkRequest
implements ReleaseExtensionDataRequest {
    private static final Log LOGGER = Log.with(ReleasesExtensionDataBulkRequest.class);
    private final Set<String> versionIds;

    private ReleasesExtensionDataBulkRequest(Set<String> versionIds) {
        this.versionIds = Collections.unmodifiableSet(versionIds);
    }

    @Override
    public Set<String> getExtensionLinks() {
        return this.versionIds;
    }

    public String toString() {
        return "ReleasesExtensionDataBulkRequest{versionIds=" + Joiner.on((String)",").join(this.versionIds) + '}';
    }

    static ReleaseExtensionDataRequest createForLink(String link) {
        return new ReleasesExtensionDataBulkRequest(Sets.newHashSet((Object[])new String[]{link}));
    }

    static ReleaseExtensionDataRequest createFromReleases(Set<IRelease> releases) {
        LOGGER.debug("create request for releases: %s", Joiner.on((String)",").join(releases));
        HashSet links = Sets.newHashSet();
        for (IRelease release : releases) {
            List<IExtensionLink> extensionLinks = release.getExtensionLinks();
            for (IExtensionLink extensionLink : extensionLinks) {
                String stringLink = extensionLink.getExtensionLink();
                if (stringLink == null) continue;
                links.add(stringLink);
            }
        }
        ReleasesExtensionDataBulkRequest request = new ReleasesExtensionDataBulkRequest(links);
        LOGGER.debug("created request: %s", request);
        return request;
    }
}

