/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.api.PluginPermission;
import com.radiantminds.roadmap.common.data.entities.common.IIdentifiable;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.handlers.BadDeveloperException;
import com.radiantminds.roadmap.common.handlers.BulkEntityContext;
import com.radiantminds.roadmap.common.handlers.EntityContextPreparationResult;
import com.radiantminds.roadmap.common.handlers.NotAuthorizedException;
import com.radiantminds.roadmap.common.handlers.SecurityAnnotations;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanFullUserAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.permissions.PlanPermission;
import com.radiantminds.roadmap.common.permissions.PlanPermissions;
import com.radiantminds.roadmap.common.permissions.PluginPermissions;
import javax.ws.rs.core.Response;

class SecureBulkEntityContextInitializer {
    private final PortfolioPlanPersistence planPersistence;
    private final PluginPermissions pluginPermissionHandler;
    private final PlanPermissions planPermissionHandler;
    private final SecurityAnnotations securityConfig;

    SecureBulkEntityContextInitializer(PortfolioPlanPersistence planPersistence, PluginPermissions pluginPermissionHandler, PlanPermissions planPermissionHandler, SecurityAnnotations securityConfig) {
        this.planPersistence = planPersistence;
        this.pluginPermissionHandler = pluginPermissionHandler;
        this.planPermissionHandler = planPermissionHandler;
        this.securityConfig = securityConfig;
    }

    <U extends IIdentifiable> Optional<Response> initialize(BulkEntityContext<U> uEntityContext, IEntityPersistence<U> uiEntityPersistence) throws Exception {
        return SecureBulkEntityContextInitializer.initialize(uEntityContext, uiEntityPersistence, this.planPersistence, this.pluginPermissionHandler, this.planPermissionHandler, this.securityConfig);
    }

    static <U extends IIdentifiable> Optional<Response> initialize(BulkEntityContext<U> bulkEntityContext, IEntityPersistence<U> entityPersistence, PortfolioPlanPersistence planPersistence, PluginPermissions pluginPermissionHandler, PlanPermissions planPermissionHandler, SecurityAnnotations securityConfig) throws Exception {
        if (securityConfig.getPlanFullUserAccess().isPresent()) {
            if (((AuthorizedPlanFullUserAccess)securityConfig.getPlanFullUserAccess().get()).entityNeeded()) {
                throw new BadDeveloperException("Dear developer; automated entity retrieval is not (yet) supported for bulk. Need it, code it.");
            }
            EntityContextPreparationResult preparationResult = bulkEntityContext.prepare(entityPersistence, planPersistence, planPermissionHandler, PlanPermission.Editor);
            if (preparationResult.getDirectResponse().isPresent()) {
                return preparationResult.getDirectResponse();
            }
            if (preparationResult.getPlanPermissionCheckResult().needsPluginPermission() && !pluginPermissionHandler.checkOr(PluginPermission.FullEditor)) {
                throw new NotAuthorizedException();
            }
            bulkEntityContext.init(preparationResult, VersionIncrementMode.isIncrement(((AuthorizedPlanFullUserAccess)securityConfig.getPlanFullUserAccess().get()).incrementEntityVersion()), VersionIncrementMode.isIncrement(((AuthorizedPlanFullUserAccess)securityConfig.getPlanFullUserAccess().get()).incrementPlanVersion()), VersionIncrementMode.isIncrement(((AuthorizedPlanFullUserAccess)securityConfig.getPlanFullUserAccess().get()).incrementSchedulingVersion()), ((AuthorizedPlanFullUserAccess)securityConfig.getPlanFullUserAccess().get()).incrementSchedulingVersion() == VersionIncrementMode.Dynamic);
        } else if (securityConfig.getPlanUserAccess().isPresent()) {
            if (((AuthorizedPlanUserAccess)securityConfig.getPlanUserAccess().get()).entityNeeded()) {
                throw new BadDeveloperException("Dear developer; automated entity retrieval is not (yet) supported for bulk. Need it, code it.");
            }
            EntityContextPreparationResult preparationResult = bulkEntityContext.prepare(entityPersistence, planPersistence, planPermissionHandler, PlanPermission.Editor);
            if (preparationResult.getDirectResponse().isPresent()) {
                return preparationResult.getDirectResponse();
            }
            if (preparationResult.getPlanPermissionCheckResult().needsPluginPermission() && !pluginPermissionHandler.checkOr(PluginPermission.FullEditor, PluginPermission.NonPublishingEditor)) {
                throw new NotAuthorizedException();
            }
            bulkEntityContext.init(preparationResult, VersionIncrementMode.isIncrement(((AuthorizedPlanUserAccess)securityConfig.getPlanUserAccess().get()).incrementEntityVersion()), VersionIncrementMode.isIncrement(((AuthorizedPlanUserAccess)securityConfig.getPlanUserAccess().get()).incrementPlanVersion()), VersionIncrementMode.isIncrement(((AuthorizedPlanUserAccess)securityConfig.getPlanUserAccess().get()).incrementSchedulingVersion()), ((AuthorizedPlanUserAccess)securityConfig.getPlanUserAccess().get()).incrementSchedulingVersion() == VersionIncrementMode.Dynamic);
        } else if (securityConfig.getPlanReadAccess().isPresent()) {
            if (((AuthorizedPlanReadAccess)securityConfig.getPlanReadAccess().get()).entityNeeded()) {
                throw new BadDeveloperException("Dear developer; automated entity retrieval is not (yet) supported for bulk. Need it, code it.");
            }
            EntityContextPreparationResult preparationResult = bulkEntityContext.prepare(entityPersistence, planPersistence, planPermissionHandler, PlanPermission.Editor, PlanPermission.Viewer);
            if (preparationResult.getDirectResponse().isPresent()) {
                return preparationResult.getDirectResponse();
            }
            if (preparationResult.getPlanPermissionCheckResult().needsPluginPermission() && !pluginPermissionHandler.checkOr(PluginPermission.FullEditor, PluginPermission.NonPublishingEditor, PluginPermission.Viewer)) {
                throw new NotAuthorizedException();
            }
            bulkEntityContext.init(preparationResult, false, false, false, false);
        } else {
            throw new BadDeveloperException("Dear developer; thou shall not use bulk entity context without a plan access annotation.");
        }
        return Optional.absent();
    }
}

