/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.persons;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPersonPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.filters.IDescribableFilter;
import com.radiantminds.roadmap.common.extensions.users.UserExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.rest.entities.common.RestDescribableFilter;
import com.radiantminds.roadmap.common.rest.entities.system.RestCommonRoadmapUser;
import com.radiantminds.roadmap.common.rest.entities.system.RestGroupAndUserListItem;
import com.radiantminds.roadmap.common.rest.entities.system.RestUserSearchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;

public interface PlanUserServiceHandler {
    @AuthorizedPlanReadAccess
    public Response listAllUsersWithPost(EntityContext<IPlan> var1, RestDescribableFilter var2) throws Exception;

    public static class Impl
    implements PlanUserServiceHandler {
        private final String EXTERNAL_ID_PREFIX = "JIRA-";
        private final int MAX_USERS = 50;
        private final PortfolioPersonPersistence personPersistence;
        private final UserExtension userExtension;

        public Impl(PortfolioPersonPersistence personPersistence, UserExtension userExtension) {
            this.personPersistence = personPersistence;
            this.userExtension = userExtension;
        }

        @Override
        public Response listAllUsersWithPost(EntityContext<IPlan> entityContext, RestDescribableFilter filter) throws Exception {
            String planId = entityContext.getEntityId();
            ArrayList externalIds = Lists.newArrayList();
            List<Object> retVal = Lists.newArrayList();
            for (IPerson iPerson : this.personPersistence.listAllPersonsWithoutAbilities(planId, true)) {
                if (iPerson.getExternalId().isPresent()) {
                    String externalId = (String)iPerson.getExternalId().get();
                    externalIds.add(externalId.substring("JIRA-".length()));
                }
                if (!Impl.applies(iPerson, filter)) continue;
                retVal.add(new RestCommonRoadmapUser(iPerson));
            }
            int remainingSlots = 51 - retVal.size();
            if (remainingSlots > 0) {
                for (RestGroupAndUserListItem user : this.userExtension.listUsers(filter.getTitle(), externalIds, remainingSlots)) {
                    retVal.add(new RestCommonRoadmapUser(user, "JIRA-"));
                }
            }
            int n = retVal.size();
            retVal = Impl.sortUsers((List<RestCommonRoadmapUser>)retVal);
            retVal = retVal.subList(0, Math.min(retVal.size(), 50));
            return entityContext.ok(new RestUserSearchResult(retVal, n));
        }

        private static List<RestCommonRoadmapUser> sortUsers(List<RestCommonRoadmapUser> list) {
            Function<RestCommonRoadmapUser, String> toStringFunction = new Function<RestCommonRoadmapUser, String>(){

                public String apply(@Nullable RestCommonRoadmapUser user) {
                    if (user != null && user.getTitle() != null) {
                        return user.getTitle();
                    }
                    return "";
                }
            };
            Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER);
            Ordering ordering = Ordering.natural().onResultOf((Function)toStringFunction);
            return ImmutableList.copyOf((Collection)ordering.sortedCopy(list));
        }

        private static boolean applies(IPerson user, IDescribableFilter filter) {
            return Impl.checkFilter(user.getTitle(), filter.getTitle()) || Impl.checkFilter(user.getDetails(), filter.getTitle());
        }

        private static boolean checkFilter(String haystack, String needle) {
            if (needle == null) {
                return true;
            }
            if (haystack == null) {
                return false;
            }
            return haystack.toLowerCase().contains(needle.toLowerCase());
        }
    }
}

