/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.streams;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.ntom.sql.StreamToTeamSql;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtension;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtensionsDataRetrieval;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.releases.RestStream;
import com.radiantminds.roadmap.common.rest.services.streams.PlanStreamServiceHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/plans/{id}/streams")
@Component
public class PlanStreamService {
    private final PlanStreamServiceHandler handler;

    @Autowired
    public PlanStreamService(PersistenceIndex persistenceIndex, SecuredInvocationHandlerFactory handlerFactory, ActiveObjectsUtilities activeObjectsUtilities, PortfolioPlanPersistence planPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioTeamPersistence teamPersistence, PortfolioStreamPersistence streamPersistence, PortfolioReleasePersistence releasePersistence, ReleaseExtension releaseExtension) {
        this.handler = handlerFactory.createProxy(PlanStreamServiceHandler.class, new PlanStreamServiceHandler.Impl(activeObjectsUtilities, planPersistence, streamPersistence, releasePersistence, teamPersistence, workItemPersistence, ReleaseExtensionsDataRetrieval.create(releaseExtension), new StreamToTeamSql(persistenceIndex, activeObjectsUtilities)), planPersistence);
    }

    @DELETE
    @Path(value="/last")
    public Response deleteLastStream(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, @QueryParam(value="deleteReleases") Boolean deleteReleases) throws Exception {
        return this.handler.deleteLastStream(EntityContext.from(planId, expectedPlanVersion, clientId), deleteReleases);
    }

    @GET
    public Response getAllStreams(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion) throws Exception {
        return this.handler.getAllStreams(EntityContext.from(planId, expectedPlanVersion));
    }

    @POST
    @Path(value="/create")
    public Response addFirstReleaseStream(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, @QueryParam(value="mode") String mode, RestStream newStream) throws Exception {
        return this.handler.addFirstReleaseStream(EntityContext.from(planId, expectedPlanVersion, clientId), mode, newStream);
    }

    @POST
    public Response addStreamToPlan(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestStream newStream) throws Exception {
        return this.handler.addStreamToPlan(EntityContext.from(planId, expectedPlanVersion, clientId), newStream);
    }

    @PUT
    @Path(value="/rank")
    public Response rankStream(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestRank rank) throws Exception {
        return this.handler.rankStream(EntityContext.from(planId, expectedPlanVersion, clientId), rank);
    }
}

