/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.dependencies;

import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestDependency;
import com.radiantminds.roadmap.common.rest.entities.workitems.dependencies.RestWorkItemDependencies;
import com.radiantminds.roadmap.common.rest.services.workitems.constraints.WorkItemConstraintChecker;
import java.util.List;
import javax.ws.rs.core.Response;

public interface WorkItemDependencyServiceHandler {
    @AuthorizedPlanReadAccess
    public Response getDependenciesForWorkItem(EntityContext<IWorkItem> var1, Boolean var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response deleteDependency(EntityContext<IWorkItem> var1, String var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response setDependency(EntityContext<IWorkItem> var1, List<RestDependency> var2) throws Exception;

    public static class Impl
    implements WorkItemDependencyServiceHandler {
        private final PortfolioWorkItemPersistence workItemPersistence;
        private final WorkItemConstraintChecker workItemConstraintChecker;

        public Impl(PortfolioWorkItemPersistence workItemPersistence) {
            this.workItemPersistence = workItemPersistence;
            this.workItemConstraintChecker = new WorkItemConstraintChecker(workItemPersistence);
        }

        @Override
        public Response deleteDependency(EntityContext<IWorkItem> entityContext, String dependee) throws Exception {
            this.workItemPersistence.removeDependency(entityContext.getEntityId(), dependee);
            return entityContext.ok(new ModificationResult());
        }

        @Override
        public Response getDependenciesForWorkItem(EntityContext<IWorkItem> entityContext, Boolean includeDone) throws Exception {
            RestWorkItemDependencies entity = this.workItemPersistence.getDependencies(entityContext.getEntityId(), Boolean.TRUE.equals(includeDone));
            return entityContext.ok(entity);
        }

        @Override
        public Response setDependency(EntityContext<IWorkItem> entityContext, List<RestDependency> dependencies) throws Exception {
            for (RestDependency dependency : dependencies) {
                if (!this.workItemConstraintChecker.isDependable(dependency.getId())) {
                    return ResponseBuilder.badRequest(RestMessaging.error("type-not-dependable"));
                }
                if (dependency.getPrerequisites() == null) continue;
                for (String id : dependency.getPrerequisites()) {
                    if (this.workItemConstraintChecker.isDependable(id)) continue;
                    return ResponseBuilder.badRequest(RestMessaging.error("type-not-dependable"));
                }
            }
            for (RestDependency dependency : dependencies) {
                this.workItemPersistence.setDependencies(dependency.getId(), dependency.getPrerequisites());
            }
            return entityContext.ok(new ModificationResult());
        }
    }
}

