/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.backlog;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.TooSmallEstimatesViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.ITimePlan;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.ActivitySet;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivitySet;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.UnstructuredItem;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingConfig;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.AssignmentTransformationResult;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.AssignmentTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.TemporalRestrictionTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.WorkDemandCalculator;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.WorkItemTransformationResult;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.TeamsTransformationResult;
import java.util.HashSet;

class WorkItemTransformer {
    private static final Log LOGGER = Log.with(WorkItemTransformer.class);
    private final ITimeTransformer timeTransformer;
    private final AssignmentTransformer assignmentTransformer;
    private final TemporalRestrictionTransformer temporalAssignmentRestrictionTransformer;
    private final WorkDemandCalculator workDemandCalculator;

    WorkItemTransformer(ITimeTransformer timeTransformer, AssignmentTransformer assignmentTransformer, TemporalRestrictionTransformer temporalAssignmentRestrictionTransformer, WorkDemandCalculator workDemandCalculator) {
        this.timeTransformer = timeTransformer;
        this.assignmentTransformer = assignmentTransformer;
        this.temporalAssignmentRestrictionTransformer = temporalAssignmentRestrictionTransformer;
        this.workDemandCalculator = workDemandCalculator;
    }

    WorkItemTransformer(ITimeTransformer timeTransformer, SchedulingConfig schedulingConfig) {
        this(timeTransformer, new AssignmentTransformer(schedulingConfig), new TemporalRestrictionTransformer(), new WorkDemandCalculator(timeTransformer));
    }

    WorkItemTransformationResult transform(SchedulingWorkItem workItem, int index, long earliestStart, ITimePlan timePlan, IProcessingDefinition processingDefinition, TeamsTransformationResult teamTransformationResult) {
        LOGGER.debug("create processing item for: %s", workItem);
        HashSet violations = Sets.newHashSet();
        Optional<IAggregatedWorkPackage> workDemand = this.workDemandCalculator.tryCreateWorkDemand(workItem, processingDefinition.getProcessingStages());
        if (!workDemand.isPresent()) {
            LOGGER.debug("no valid work demand for work item: %s", workItem);
            violations.add(new TooSmallEstimatesViolation(workItem.getId()));
        }
        AssignmentTransformationResult assignment = this.assignmentTransformer.tryTransformAssignment(workItem, teamTransformationResult, (IAggregatedWorkPackage)workDemand.orNull());
        violations.addAll(assignment.getViolations());
        if (violations.isEmpty()) {
            if (workItem.getType().equals(WorkItems.Types.EPIC)) {
                UnstructuredItem unstructuredItem = new UnstructuredItem(workItem.getId(), null, index, this.timeTransformer.getZeroInstantSafeTimestep(earliestStart), (IAggregatedWorkPackage)workDemand.get(), (AssignmentRestriction)assignment.tryGetAssignment().get(), this.temporalAssignmentRestrictionTransformer.transform(timePlan, workItem), workItem.getSortOrder().toString());
                LOGGER.debug("created unstructured processing item: %s", unstructuredItem);
                return new WorkItemTransformationResult(violations, unstructuredItem);
            }
            IActivitySet activitySet = ActivitySet.createInstance(workItem.getId(), null, index, (IAggregatedWorkPackage)workDemand.get(), (AssignmentRestriction)assignment.tryGetAssignment().get(), this.temporalAssignmentRestrictionTransformer.transform(timePlan, workItem), workItem.getSortOrder().toString(), this.timeTransformer.getZeroInstantSafeTimestep(earliestStart));
            LOGGER.debug("created activity set: %s", activitySet);
            return new WorkItemTransformationResult(violations, activitySet);
        }
        return new WorkItemTransformationResult(violations, null);
    }
}

