/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.settings;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.google.common.collect.BiMap;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.skills.SchedulingSkill;
import com.radiantminds.roadmap.common.data.entities.skills.SchedulingStage;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.IResourceTypeMapping;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ResourceTypeMapping
implements IResourceTypeMapping {
    private final BiMap<SchedulingStage, IResourceType> stageToTypeMap;
    private final BiMap<SchedulingSkill, IResourceType> skillToTypeMap;

    ResourceTypeMapping(BiMap<SchedulingStage, IResourceType> stageToTypeMap, BiMap<SchedulingSkill, IResourceType> skillToTypeMap) {
        this.stageToTypeMap = stageToTypeMap;
        this.skillToTypeMap = skillToTypeMap;
    }

    @Override
    public BiMap<SchedulingSkill, IResourceType> getSkillTypeMapping() {
        return this.skillToTypeMap;
    }

    @Override
    public BiMap<SchedulingStage, IResourceType> getStageTypeMapping() {
        return this.stageToTypeMap;
    }

    @Override
    public boolean isEmpty() {
        return this.stageToTypeMap.isEmpty() && this.skillToTypeMap.isEmpty();
    }

    @Override
    public Set<IResourceType> getResourceTypesForStage(SchedulingStage stage) {
        if (this.stageToTypeMap.containsKey((Object)stage)) {
            return Sets.newHashSet((Object[])new IResourceType[]{(IResourceType)this.stageToTypeMap.get((Object)stage)});
        }
        HashSet filtered = Sets.newHashSet();
        for (Map.Entry entry : this.skillToTypeMap.entrySet()) {
            if (!((SchedulingSkill)entry.getKey()).getStageId().equals(stage.getId())) continue;
            filtered.add(entry.getValue());
        }
        return filtered;
    }
}

