/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.stats;

import com.google.common.base.Preconditions;
import com.radiantminds.roadmap.common.stats.MonitorMetric;
import com.radiantminds.roadmap.common.stats.Unit;
import javax.annotation.concurrent.Immutable;

@Immutable
public class RuntimeMsMetric
implements MonitorMetric<Long> {
    private final String id;
    private final long duration;

    public RuntimeMsMetric(String id, long duration) {
        this.id = id;
        this.duration = duration;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Long getValue() {
        return this.duration;
    }

    @Override
    public Unit getUnit() {
        return Unit.Ms;
    }

    static RuntimeMsMetric create(String id, long startMs) {
        return new RuntimeMsMetric((String)Preconditions.checkNotNull((Object)id), System.currentTimeMillis() - startMs);
    }
}

