/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.issues;

import com.atlassian.jira.issue.fields.CustomField;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFields;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SyncableFields {
    private final CustomFields customFields;

    @Autowired
    public SyncableFields(CustomFields customFields) {
        this.customFields = customFields;
    }

    public Optional<String> getEpicLabelFieldKey() {
        CustomField epicTitleField = this.customFields.tryGetEpicLabelField();
        if (epicTitleField != null) {
            return Optional.of((Object)epicTitleField.getNameKey());
        }
        return Optional.absent();
    }

    public Optional<String> getStoryPointsFieldKey() {
        CustomField storyPointsCustomField = this.customFields.tryGetStoryPointsCustomField();
        if (storyPointsCustomField != null) {
            return Optional.of((Object)storyPointsCustomField.getNameKey());
        }
        return Optional.absent();
    }

    public List<String> getSyncableFieldKeys() {
        Optional<String> storyPointsFieldKey;
        ArrayList syncables = Lists.newArrayList((Object[])new String[]{"summary", "description", "timeoriginalestimate"});
        Optional<String> epicLabelFieldKey = this.getEpicLabelFieldKey();
        if (epicLabelFieldKey.isPresent()) {
            syncables.add(epicLabelFieldKey.get());
        }
        if ((storyPointsFieldKey = this.getStoryPointsFieldKey()).isPresent()) {
            syncables.add(storyPointsFieldKey.get());
        }
        return syncables;
    }
}

