/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IActivitySetSchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.IGroupActivitySchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivity;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IRoadmapProblemStatistics;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IStageTask;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.atlassian.rm.jpo.scheduling.util.function.IntegerInterval;
import com.google.common.base.Optional;
import com.google.common.collect.BiMap;
import java.util.List;
import java.util.Set;

public class GroupActivitySchedulingProblem
implements IGroupActivitySchedulingProblem {
    private final IActivity activity;
    private final IWorkSlot firstPossibleWorkSlot;
    private final IRoadmapProblemStatistics projectStatistics;
    private final int releaseTime;
    private final String itemId;
    private final IMutableResourceGroup resourceGroup;
    private final IEpisode episode;
    private final int maxResources;
    private final int upperTimeBound;
    private final BiMap<String, IResourceType> types;
    private final BiMap<String, IMutableResource> resources;
    private final AssignmentRestriction assignmentRestriction;

    private GroupActivitySchedulingProblem(String itemId, IActivity activity, IWorkSlot firstPossibleWorkSlot, IRoadmapProblemStatistics projectStatistics, int releaseTime, int upperTimeBound, IMutableResourceGroup workSlotDefinition, IEpisode episode, int maxResources, BiMap<String, IResourceType> types, BiMap<String, IMutableResource> resources, AssignmentRestriction assignmentRestriction) {
        this.itemId = itemId;
        this.activity = activity;
        this.firstPossibleWorkSlot = firstPossibleWorkSlot;
        this.projectStatistics = projectStatistics;
        this.releaseTime = releaseTime;
        this.upperTimeBound = upperTimeBound;
        this.resourceGroup = workSlotDefinition;
        this.episode = episode;
        this.maxResources = maxResources;
        this.types = types;
        this.resources = resources;
        this.assignmentRestriction = assignmentRestriction;
    }

    @Override
    public IActivity getActivity() {
        return this.activity;
    }

    @Override
    public IRoadmapProblemStatistics getProjectStatistics() {
        return this.projectStatistics;
    }

    @Override
    public IWorkSlot getFirstPossibleWorkSlot() {
        return this.firstPossibleWorkSlot;
    }

    @Override
    public int getLowerTimeBound() {
        return this.releaseTime;
    }

    @Override
    public String getItemId() {
        return this.itemId;
    }

    @Override
    public IMutableResourceGroup getResourceGroup() {
        return this.resourceGroup;
    }

    @Override
    public IEpisode getProjectEpisode() {
        return this.episode;
    }

    @Override
    public Set<IMutableResource> getMutableResources() {
        return this.resources.values();
    }

    @Override
    public int getMaxResources() {
        return this.maxResources;
    }

    @Override
    public int getUpperTimeBound() {
        return this.upperTimeBound;
    }

    @Override
    public IWorkResource getResource(String id) {
        return (IWorkResource)this.resources.get((Object)id);
    }

    @Override
    public IResourceType getType(String id) {
        return (IResourceType)this.types.get((Object)id);
    }

    @Override
    public Optional<IIntegerInterval> tryCreateSolutionInterval(int timeLimit) {
        int endTime;
        int startTime = this.getLowerTimeBound();
        List<IWorkSlot> workSlotsBetween = this.resourceGroup.getWorkSlotsBetween(startTime, endTime = Math.min(this.getUpperTimeBound(), timeLimit));
        if (workSlotsBetween.isEmpty()) {
            return Optional.absent();
        }
        int startIndex = workSlotsBetween.get(0).getIndex();
        int endIndex = workSlotsBetween.get(workSlotsBetween.size() - 1).getIndex();
        IntegerInterval interval = new IntegerInterval(startIndex, endIndex);
        return Optional.of((Object)interval);
    }

    @Override
    public PositivePrimitivesMap<IResourceType> getOverallDemand() {
        return this.activity.getOverallDemand();
    }

    @Override
    public List<IStageTask> getStageTasks() {
        return this.activity.getStageTasks();
    }

    public static Optional<IGroupActivitySchedulingProblem> tryCreateActivitySchedulingProblem(IActivitySetSchedulingProblem problem, IActivity activity, int activityReleaseTime, IMutableResourcePool mutableResourcePool) throws InterruptedException {
        if (problem.getMaxResourcesPerStage() <= 0) {
            return Optional.absent();
        }
        BiMap<String, IResourceType> typeMap = RmIdentifiableUtils.createIdMap(activity.getResourceTypes());
        if (!mutableResourcePool.getResourceTypes().containsAll(typeMap.values())) {
            return Optional.absent();
        }
        BiMap<String, IMutableResource> resourceMap = RmIdentifiableUtils.createIdMap(mutableResourcePool.getMutableResources());
        GroupActivitySchedulingProblem instance = new GroupActivitySchedulingProblem(problem.getId(), activity, mutableResourcePool.getNextValidWorkSlotForReleaseTime(activityReleaseTime), problem.getProjectStatistics(), activityReleaseTime, problem.getUpperTimeBound(), mutableResourcePool.getMutableResourceGroup(), problem.getProjectEpisode(), problem.getMaxResourcesPerStage(), typeMap, resourceMap, problem.getActivitySet().getAssignmentRestriction());
        return Optional.of((Object)instance);
    }

    @Override
    public AssignmentRestriction getAssignmentRestriction() {
        return this.assignmentRestriction;
    }
}

