/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.common;

import com.google.common.base.Predicate;
import com.radiantminds.roadmap.common.data.entities.people.ISprint;
import javax.annotation.Nullable;

class ValidSprintPredicate
implements Predicate<ISprint> {
    private final long lowerTimeLimit;

    ValidSprintPredicate(long lowerTimeLimit) {
        this.lowerTimeLimit = lowerTimeLimit;
    }

    public boolean apply(@Nullable ISprint sprint) {
        if (sprint == null) {
            return false;
        }
        if (sprint.getStartDate() == null || sprint.getEndDate() == null) {
            return false;
        }
        if (sprint.getStartDate() > sprint.getEndDate()) {
            return false;
        }
        return sprint.getEndDate() >= this.lowerTimeLimit;
    }
}

