/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.kanban;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkSlotFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.Resource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositivePrimitivesMap;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingPerson;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingResource;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.IResourceTypeMapping;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.SupplyFactorMapCreator;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.WorkFunctionCreator;
import javax.annotation.concurrent.Immutable;

@Immutable
class KanbanResourceTransformer {
    private static final Log LOGGER = Log.with(KanbanResourceTransformer.class);
    private final WorkFunctionCreator workFunctionCreator;
    private final SupplyFactorMapCreator supplyFactorMapCreator;

    KanbanResourceTransformer(WorkFunctionCreator workFunctionCreator, SupplyFactorMapCreator supplyFactorMapCreator) {
        this.workFunctionCreator = workFunctionCreator;
        this.supplyFactorMapCreator = supplyFactorMapCreator;
    }

    KanbanResourceTransformer(ITimeTransformer timeTransformer, TimeStepPresenceFunction workDayFunction) {
        this(new WorkFunctionCreator(timeTransformer, workDayFunction), new SupplyFactorMapCreator());
    }

    Optional<IWorkResource> tryCreateWorkResource(SchedulingResource resource, SchedulingPerson person, SchedulingTeam team, IResourceTypeMapping resourceTypeMapping, WorkSlotsDefinition workSlotsDefinition) {
        LOGGER.debug("create multi resource for resource: %s", resource);
        String id = resource.getId();
        Optional<ImmutableNonEmptyPositivePrimitivesMap<IResourceType>> resourceSupplyMap = this.supplyFactorMapCreator.createSupplyMap(person, resourceTypeMapping);
        if (!resourceSupplyMap.isPresent()) {
            LOGGER.debug("resource has no needed skills - ignored", new Object[0]);
            return Optional.absent();
        }
        Optional<IWorkSlotFunction> availabilityFunction = this.workFunctionCreator.tryCreateWorkSlotAvailability(resource, person, workSlotsDefinition);
        if (!availabilityFunction.isPresent()) {
            LOGGER.debug("no availability function created - ignored", new Object[0]);
            return Optional.absent();
        }
        String sortKey = team.getSortOrder().toString() + "-" + resource.getSortOrder().toString();
        Resource workResource = new Resource(id, team.getId(), (ImmutableNonEmptyPositivePrimitivesMap)resourceSupplyMap.get(), (IWorkSlotFunction)availabilityFunction.get(), null, sortKey);
        LOGGER.debug("created multi resource: %s", workResource);
        return Optional.of((Object)workResource);
    }
}

