/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.point;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.AdjustedGroupPointsResourceSupplyFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.LinearTeamVelocityFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkSlotFunction;
import com.atlassian.rm.jpo.scheduling.util.function.IImmutableDiscreteStepFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingPerson;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingResource;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.data.entities.plans.PersonMapping;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.WorkFunctionCreator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AdjustedResourceRatioSupplyFunctionCreator {
    private final WorkFunctionCreator workFunctionCreator;
    private final TimeStepPresenceFunction timeStepPresenceFunction;

    AdjustedResourceRatioSupplyFunctionCreator(WorkFunctionCreator workFunctionCreator, TimeStepPresenceFunction timeStepPresenceFunction) {
        this.workFunctionCreator = workFunctionCreator;
        this.timeStepPresenceFunction = timeStepPresenceFunction;
    }

    public AdjustedResourceRatioSupplyFunctionCreator(ITimeTransformer timeTransformer, TimeStepPresenceFunction timeStepPresenceFunction) {
        this(new WorkFunctionCreator(timeTransformer, timeStepPresenceFunction), timeStepPresenceFunction);
    }

    public Map<SchedulingResource, IWorkSlotFunction> getResourceSupplyFunctions(List<? extends SchedulingResource> resources, PersonMapping plan, WorkSlotsDefinition workSlotsDefinition, float velocity, float increment) {
        LinearTeamVelocityFunction fixedTeamVelocity = new LinearTeamVelocityFunction(velocity, increment, workSlotsDefinition, this.timeStepPresenceFunction);
        HashMap supplies = Maps.newHashMap();
        Preconditions.checkNotNull(resources, (Object)"resources must not be null");
        Preconditions.checkArgument((!resources.isEmpty() ? 1 : 0) != 0, (Object)"resources must be available");
        IImmutableDiscreteStepFunction teamDefaultAvailability = this.getDefaultAvailabilitySum(resources, workSlotsDefinition);
        Map<SchedulingResource, IWorkSlotFunction> availabilities = this.getSupplies(resources, workSlotsDefinition, plan);
        for (Map.Entry<SchedulingResource, IWorkSlotFunction> entry : availabilities.entrySet()) {
            AdjustedGroupPointsResourceSupplyFunction availability = new AdjustedGroupPointsResourceSupplyFunction(entry.getValue(), teamDefaultAvailability, fixedTeamVelocity, workSlotsDefinition);
            supplies.put(entry.getKey(), availability);
        }
        return supplies;
    }

    private IImmutableDiscreteStepFunction getDefaultAvailabilitySum(final List<? extends SchedulingResource> resources, final WorkSlotsDefinition slotsDefinition) {
        return new IImmutableDiscreteStepFunction(){

            @Override
            public float getAt(int x) {
                IWorkSlot slot = slotsDefinition.getWorkSlotWithIndex(x);
                float sum = 0.0f;
                for (int i = slot.getStart(); i <= slot.getEnd(); ++i) {
                    if (!AdjustedResourceRatioSupplyFunctionCreator.this.timeStepPresenceFunction.isWorkTimeStep(i)) continue;
                    for (SchedulingResource resource : resources) {
                        Double availability = resource.getAvailability();
                        if (availability == null) {
                            sum += AdjustedResourceRatioSupplyFunctionCreator.this.timeStepPresenceFunction.getDefaultWeeklyHours() / (float)AdjustedResourceRatioSupplyFunctionCreator.this.timeStepPresenceFunction.getWeeklyWorkDays();
                            continue;
                        }
                        sum = (float)((double)sum + availability / (double)AdjustedResourceRatioSupplyFunctionCreator.this.timeStepPresenceFunction.getWeeklyWorkDays());
                    }
                }
                return sum;
            }
        };
    }

    private Map<SchedulingResource, IWorkSlotFunction> getSupplies(List<? extends SchedulingResource> resources, WorkSlotsDefinition workSlotsDefinition, PersonMapping personMapping) {
        HashMap availabilities = Maps.newHashMap();
        for (SchedulingResource schedulingResource : resources) {
            SchedulingPerson person;
            IWorkSlotFunction resourceAvailabilityFunction = (IWorkSlotFunction)this.workFunctionCreator.tryCreateWorkSlotAvailability(schedulingResource, person = (SchedulingPerson)personMapping.getPerson(schedulingResource.getPersonId()).get(), workSlotsDefinition).orNull();
            if (resourceAvailabilityFunction == null) continue;
            availabilities.put(schedulingResource, resourceAvailabilityFunction);
        }
        return availabilities;
    }

    Map<SchedulingResource, IWorkSlotFunction> getResourceSupplyFunctions(SchedulingTeam team, PersonMapping personMapping, WorkSlotsDefinition workSlotsDefinition, float velocity) {
        return this.getResourceSupplyFunctions(team.getResources(), personMapping, workSlotsDefinition, velocity, this.getIncrement(team.getIncrementalAdjustment()));
    }

    private float getIncrement(Double increment) {
        if (increment != null) {
            return increment.floatValue();
        }
        return 0.0f;
    }
}

