/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.estimate.AOEstimate;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WorkItemEstimateSQL
extends BaseAOPersistenceSQL {
    public WorkItemEstimateSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public Map<String, Double> getTotalRemainingEstimates(final String planId, Set<String> originalWorkItemIds) throws SQLException {
        final HashSet workItemIds = Sets.newHashSet(originalWorkItemIds);
        boolean includeNoInititiave = false;
        if (workItemIds.contains("-1")) {
            workItemIds.remove("-1");
            includeNoInititiave = true;
        }
        final boolean noInitiative = includeNoInititiave;
        return this.sql(new IQuery<Map<String, Double>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                int i;
                final ArrayList hierarchies = Lists.newArrayList();
                for (i = 0; i < 3; ++i) {
                    hierarchies.add("w" + i);
                    generator.withTable(AOWorkItem.class, (String)hierarchies.get(i));
                }
                generator.withTable(AOEstimate.class, "e").select().colId((String)hierarchies.get(0)).col((String)hierarchies.get(0), "type").col((String)hierarchies.get(0), "aoParent").raw(", SUM(").col("e", "estimate").raw(")").from(new String[0]).table((String)hierarchies.get(0));
                for (i = 1; i < hierarchies.size(); ++i) {
                    generator.leftJoin().table((String)hierarchies.get(i)).on().colId((String)hierarchies.get(i - 1)).eq().col((String)hierarchies.get(i), "aoParent");
                }
                generator.leftJoin().table("e").on().raw("(");
                for (i = 0; i < hierarchies.size(); ++i) {
                    if (i > 0) {
                        generator.or();
                    }
                    generator.col("e", "aoWorkItem").eq().colId((String)hierarchies.get(i));
                }
                generator.raw(")").and().col("e", "replanning").eq().bool(false).and().col("e", "original").eq().bool(false).where().raw("(");
                if (workItemIds.size() > 0) {
                    generator.inNumeric(new AOQueryGenerator.InOperandCallback(){

                        @Override
                        public void generateOperand(AOQueryGenerator generator) {
                            generator.colId((String)hierarchies.get(0));
                        }
                    }, workItemIds);
                }
                if (noInitiative) {
                    if (workItemIds.size() > 0) {
                        generator.or();
                    }
                    generator.raw("(").col((String)hierarchies.get(0), "aoPlan").eq().numeric(planId).and().col((String)hierarchies.get(0), "type").eq().numeric(WorkItems.Types.EPIC).and().col((String)hierarchies.get(0), "aoParent").isNull().raw(")");
                }
                generator.raw(")").groupBy().colId((String)hierarchies.get(0)).col((String)hierarchies.get(0), "type").col((String)hierarchies.get(0), "aoParent");
            }

            @Override
            public Map<String, Double> handleResult(ResultSet result) throws Exception {
                HashMap retVal = Maps.newHashMap();
                while (result.next()) {
                    String id = BaseAOPersistenceSQL.getString(result, 1);
                    Integer type = WorkItemEstimateSQL.getInteger(result, 2);
                    String parentId = BaseAOPersistenceSQL.getString(result, 3);
                    Double estimateSum = BaseAOPersistenceSQL.getDouble(result, 4);
                    if (workItemIds.contains(id)) {
                        retVal.put(id, estimateSum);
                    }
                    if (estimateSum == null || !noInitiative || !WorkItems.Types.EPIC.equals(type) || parentId != null) continue;
                    if (!retVal.containsKey("-1")) {
                        retVal.put("-1", 0.0);
                    }
                    retVal.put("-1", (Double)retVal.get("-1") + estimateSum);
                }
                return retVal;
            }
        });
    }

    public Map<String, Double> getTotalOriginalEstimates(final String planId, Set<String> originalWorkItemIds) throws SQLException {
        final HashSet workItemIds = Sets.newHashSet(originalWorkItemIds);
        boolean includeNoInititiave = false;
        if (workItemIds.contains("-1")) {
            workItemIds.remove("-1");
            includeNoInititiave = true;
        }
        final boolean noInitiative = includeNoInititiave;
        return this.sql(new IQuery<Map<String, Double>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                int i;
                final ArrayList hierarchies = Lists.newArrayList();
                for (i = 0; i < 3; ++i) {
                    hierarchies.add("w" + i);
                    generator.withTable(AOWorkItem.class, (String)hierarchies.get(i));
                }
                generator.withTable(AOEstimate.class, "e").select().colId((String)hierarchies.get(0)).col((String)hierarchies.get(0), "type").col((String)hierarchies.get(0), "aoParent").raw(", SUM(").col("e", "estimate").raw("), ").colBooleanOrAggregation("e", "original").from(new String[0]).table((String)hierarchies.get(0));
                for (i = 1; i < hierarchies.size(); ++i) {
                    generator.leftJoin().table((String)hierarchies.get(i)).on().colId((String)hierarchies.get(i - 1)).eq().col((String)hierarchies.get(i), "aoParent");
                }
                generator.leftJoin().table("e").on().col("e", "replanning").eq().bool(false).and().raw("(");
                for (i = 0; i < hierarchies.size(); ++i) {
                    if (i > 0) {
                        generator.or();
                    }
                    generator.raw("(").col("e", "aoWorkItem").eq().colId((String)hierarchies.get(i)).and().col("e", "original").eq().col((String)hierarchies.get(i), "hasOriginalEstimates").raw(")");
                }
                generator.raw(")").where().raw("(");
                if (workItemIds.size() > 0) {
                    generator.inNumeric(new AOQueryGenerator.InOperandCallback(){

                        @Override
                        public void generateOperand(AOQueryGenerator generator) {
                            generator.colId((String)hierarchies.get(0));
                        }
                    }, workItemIds);
                }
                if (noInitiative) {
                    if (workItemIds.size() > 0) {
                        generator.or();
                    }
                    generator.raw("(").col((String)hierarchies.get(0), "aoPlan").eq().numeric(planId).and().col((String)hierarchies.get(0), "type").eq().numeric(WorkItems.Types.EPIC).and().col((String)hierarchies.get(0), "aoParent").isNull().raw(")");
                }
                generator.raw(")").groupBy().colId((String)hierarchies.get(0)).col((String)hierarchies.get(0), "type").col((String)hierarchies.get(0), "aoParent");
            }

            @Override
            public Map<String, Double> handleResult(ResultSet result) throws Exception {
                HashMap retVal = Maps.newHashMap();
                ArrayList noInitiativeRelevantSums = Lists.newArrayList();
                boolean noInitiativeRelevantSumIsOriginal = false;
                while (result.next()) {
                    String id = BaseAOPersistenceSQL.getString(result, 1);
                    Integer type = WorkItemEstimateSQL.getInteger(result, 2);
                    String parentId = BaseAOPersistenceSQL.getString(result, 3);
                    Double estimateSum = BaseAOPersistenceSQL.getDouble(result, 4);
                    Boolean original = BaseAOPersistenceSQL.getBoolean(result, 5);
                    if (estimateSum == null) continue;
                    if (Boolean.TRUE.equals(original) && workItemIds.contains(id)) {
                        retVal.put(id, estimateSum);
                    }
                    if (!noInitiative || !WorkItems.Types.EPIC.equals(type) || parentId != null) continue;
                    noInitiativeRelevantSums.add(estimateSum);
                    noInitiativeRelevantSumIsOriginal |= Boolean.TRUE.equals(original);
                }
                if (noInitiativeRelevantSumIsOriginal) {
                    double sum = 0.0;
                    for (Double noInitiativeSum : noInitiativeRelevantSums) {
                        sum += noInitiativeSum.doubleValue();
                    }
                    retVal.put("-1", sum);
                }
                return retVal;
            }
        });
    }

    public void clearEstimatesForWorkItem(final String workItemId, final boolean replanning, final boolean original) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOEstimate.class, "e").deleteFrom().tableNoAlias("e").where().colNoAlias("e", "replanning").eq().bool(replanning).and().colNoAlias("e", "original").eq().bool(original).and().colNoAlias("e", "aoWorkItem").eq().numeric(workItemId);
            }
        });
    }

    public boolean hasReplanningEstimates(final String id) throws SQLException {
        return this.sql(new IQuery<Boolean>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOEstimate.class, "e").select().raw("COUNT(*)").from("e").where().col("e", "aoWorkItem").eq().numeric(id).and().col("e", "replanning").eq().bool(true);
            }

            @Override
            public Boolean handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getInt(result, 1) > 0;
                }
                return false;
            }
        });
    }

    public Set<String> getItemsWithReplanningEstimates(final String planId) throws SQLException {
        return this.sql(new IQuery<Set<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOEstimate.class, "e").withTable(AOWorkItem.class, "w").select().col("e", "aoWorkItem").raw(", COUNT(*) ", false).from("e", "w").where().col("e", "aoWorkItem").eq().col("w", "ID_OTHER", false).and().col("w", "aoPlan").eq().numeric(planId).and().col("e", "replanning").eq().bool(true).groupBy().colNoAlias("e", "aoWorkItem");
            }

            @Override
            public Set<String> handleResult(ResultSet result) throws Exception {
                HashSet workItems = Sets.newHashSet();
                while (result.next()) {
                    if (BaseAOPersistenceSQL.getInt(result, 2) <= 0) continue;
                    workItems.add(BaseAOPersistenceSQL.getString(result, 1));
                }
                return workItems;
            }
        });
    }
}

