/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.settings;

import com.google.common.base.Preconditions;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.generator.settings.ISettingsConfiguration;
import com.radiantminds.roadmap.common.data.generator.settings.IStageConfiguration;
import java.util.List;

public class SettingsConfiguration
implements ISettingsConfiguration {
    private final List<IStageConfiguration> stageConfigurations;
    private final boolean sprintWarningsEnabled;
    private final boolean sprintConstraintsEnabled;
    private final long minimumWorkLoadForUnstructuredEpics;
    private final int maxAssignableResourcesPerStory;
    private final String planningUnit;

    private SettingsConfiguration(List<IStageConfiguration> stageConfigurations, boolean sprintWarningsEnabled, boolean sprintConstraintsEnabled, long minimumWorkLoadForUnstructuredEpics, int maxAssignableResourcesPerStory, String planningUnit) {
        this.stageConfigurations = stageConfigurations;
        this.sprintWarningsEnabled = sprintWarningsEnabled;
        this.sprintConstraintsEnabled = sprintConstraintsEnabled;
        this.minimumWorkLoadForUnstructuredEpics = minimumWorkLoadForUnstructuredEpics;
        this.maxAssignableResourcesPerStory = maxAssignableResourcesPerStory;
        this.planningUnit = planningUnit;
    }

    @Override
    public List<IStageConfiguration> getStageConfigurations() {
        return this.stageConfigurations;
    }

    @Override
    public boolean isSprintWarningsEnabled() {
        return this.sprintWarningsEnabled;
    }

    @Override
    public boolean isSprintConstraintEnabled() {
        return this.sprintConstraintsEnabled;
    }

    @Override
    public long getMinimumWorkLoadForUnstructuredEpics() {
        return this.minimumWorkLoadForUnstructuredEpics;
    }

    @Override
    public long getMaxAssignableResourcesPerStory() {
        return this.maxAssignableResourcesPerStory;
    }

    @Override
    public String getPlanningUnit() {
        return this.planningUnit;
    }

    public static class Builder {
        private final List<IStageConfiguration> stageConfigurations;
        private boolean sprintWarningsEnabled = false;
        private boolean sprintConstraintsEnabled = true;
        private long minimumWorkLoadForUnstructuredEpics = 5L;
        private int maxAssignableResourcesPerStory = 5;
        private String planningUnit = PlanningUnit.DAYS.toString();

        public Builder(List<IStageConfiguration> stageConfigurations) {
            this.stageConfigurations = stageConfigurations;
        }

        public Builder withSprintWarningsEnabled(boolean sprintWarningsEnabled) {
            this.sprintWarningsEnabled = sprintWarningsEnabled;
            return this;
        }

        public Builder withSprintConstraintsEnabled(boolean sprintConstraintsEnabled) {
            this.sprintConstraintsEnabled = sprintConstraintsEnabled;
            return this;
        }

        public Builder withMinimumWorkLoadForUnstructuredEpics(long minWorkLoadForUnstructuredEpics) {
            this.minimumWorkLoadForUnstructuredEpics = minWorkLoadForUnstructuredEpics;
            return this;
        }

        public Builder withMaxAssignableResourcesPerStory(int maxAssignableResourcesPerStory) {
            this.maxAssignableResourcesPerStory = maxAssignableResourcesPerStory;
            return this;
        }

        public Builder withPlanningUnit(String planningUnit) {
            Preconditions.checkArgument((PlanningUnit.DAYS.toString().equals(planningUnit) || PlanningUnit.HOURS.toString().equals(planningUnit) ? 1 : 0) != 0);
            this.planningUnit = planningUnit;
            return this;
        }

        public SettingsConfiguration build() {
            return new SettingsConfiguration(this.stageConfigurations, this.sprintWarningsEnabled, this.sprintConstraintsEnabled, this.minimumWorkLoadForUnstructuredEpics, this.maxAssignableResourcesPerStory, this.planningUnit);
        }
    }
}

