/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOAbility;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOSkill;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.sql.SkillSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class AbilitySQL
extends BaseAOPersistenceSQL {
    private final SkillSQL skillSQL;

    public AbilitySQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
        this.skillSQL = new SkillSQL(activeObjectsUtilities);
    }

    public void setAbility(String personId, String targetType, String targetId, Double value) throws SQLException {
        String existingId = this.getExistingAbilityId(personId, targetType, targetId);
        if (existingId != null) {
            if (value == null) {
                this.deleteAbility(existingId);
            } else {
                this.updateAbility(existingId, value);
            }
        } else if ("skill".equals(targetType)) {
            if (value != null) {
                this.insertAbility(personId, targetType, targetId, value);
            }
            this.deleteAbilityOnStageOfSkill(personId, targetId);
        } else if ("stage".equals(targetType)) {
            List<String> skillsInStage = this.skillSQL.getSkillIdsForStage(targetId);
            if (skillsInStage.size() == 0) {
                if (value != null) {
                    this.insertAbility(personId, targetType, targetId, value);
                }
            } else {
                for (String skillId : skillsInStage) {
                    this.setAbility(personId, "skill", skillId, value);
                }
            }
        }
    }

    private void insertAbility(final String personId, final String targetType, final String targetId, final Double value) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOAbility.class, "a").insert().tableNoAlias("a").raw("(").colNoAlias("a", "aoPerson").colNoAlias("a", "targetType").colNoAlias("a", "targetId").colNoAlias("a", "abilityValue").raw(") VALUES (").numeric(personId).raw(",").str(targetType).raw(",").numeric(targetId).raw(",").numeric(value).raw(")");
            }
        });
    }

    private void updateAbility(final String abilityId, final Double value) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOAbility.class, "a").update().tableNoAlias("a").set().colNoAlias("a", "abilityValue").eq().numeric(value).where().colIdNoAlias("a").eq().numeric(abilityId);
            }
        });
    }

    private void deleteAbilityOnStageOfSkill(final String personId, final String skillId) throws SQLException {
        final String stageId = this.sql(new IQuery<String>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOSkill.class, "s").select().col("s", "aostage").from("s").where().colId("s").eq().numeric(skillId);
            }

            @Override
            public String handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getString(result, 1);
                }
                return null;
            }
        });
        if (stageId != null) {
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOAbility.class, "a").deleteFrom().tableNoAlias("a").where().colNoAlias("a", "aoperson").eq().numeric(personId).and().colNoAlias("a", "targetType").eq().str("stage").and().colNoAlias("a", "targetId").eq().numeric(stageId);
                }
            });
        }
    }

    public void deleteAbility(final String abilityId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOAbility.class, "a").deleteFrom().tableNoAlias("a").where().colIdNoAlias("a").eq().numeric(abilityId);
            }
        });
    }

    private String getExistingAbilityId(final String personId, final String targetType, final String targetId) throws SQLException {
        return this.sql(new IQuery<String>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOAbility.class, "a").select().col("a", "ID_OTHER", false).from("a").where().col("a", "aoperson").eq().numeric(personId).and().col("a", "targetType").eq().str(targetType).and().col("a", "targetId").eq().numeric(targetId);
            }

            @Override
            public String handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getString(result, 1);
                }
                return null;
            }
        });
    }
}

