/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.plugins.jira.licenses;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.rm.common.bridges.jira.event.mau.MauEventServiceBridgeProxy;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.radiantminds.plugins.jira.views.licenses.DetailsAction;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioCustomWordingPersistence;
import com.radiantminds.roadmap.common.extensions.features.FeatureExtension;
import com.radiantminds.roadmap.common.permissions.PluginPermissions;
import com.radiantminds.roadmap.common.utils.meta.MetaDataUtils;
import com.radiantminds.roadmap.jira.common.components.agile.JiraAgileAccessor;
import com.radiantminds.roadmap.jira.common.components.extension.licenses.JiraLicenseExtension;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DetailsActionsTest {
    @Mock
    private PluginLicenseManager licenseManager;
    @Mock
    private FeatureManager featureManager;
    @Mock
    private FeatureExtension featureExtension;
    @Mock
    private ApplicationProperties applicationProperties;
    @Mock
    private JiraAuthenticationContext authenticationContext;
    @Mock
    private PluginPermissions pluginPermissionHandler;
    @Mock
    private PortfolioCustomWordingPersistence customWordingPersistence;
    @Mock
    private MetaDataUtils metaDataUtils;
    @Mock
    private JiraAgileAccessor agileAccessor;
    @Mock
    private MauEventServiceBridgeProxy mauEventServiceBridgeProxy;
    @Mock
    private JiraLicenseExtension jiraLicenseExtension;
    @Mock
    private PluginLicense pluginLicense;
    @InjectMocks
    private DetailsAction detailsAction;

    @Test
    public void testPurchaseDateIfCorrectTest() {
        DateTime testDateTime = new DateTime(2020, 8, 14, 0, 0, 0);
        PluginLicense license = (PluginLicense)Mockito.mock(PluginLicense.class);
        Option option = Option.option((Object)license);
        Mockito.when((Object)this.licenseManager.getLicense()).thenReturn((Object)option);
        Mockito.when((Object)((PluginLicense)this.licenseManager.getLicense().get()).getPurchaseDate()).thenReturn((Object)testDateTime);
        String purchaseDate = this.detailsAction.getPurchaseDate();
        Assert.assertEquals((Object)"14/Aug/20", (Object)purchaseDate);
    }

    @Test
    public void testPurchaseDateIfInCorrectTest() {
        PluginLicense license = (PluginLicense)Mockito.mock(PluginLicense.class);
        Option option = Option.option((Object)license);
        Mockito.when((Object)this.licenseManager.getLicense()).thenReturn((Object)option);
        Mockito.when((Object)((PluginLicense)this.licenseManager.getLicense().get()).getPurchaseDate()).thenReturn(null);
        String purchaseDate = this.detailsAction.getPurchaseDate();
        Assert.assertEquals((Object)"Unknown", (Object)purchaseDate);
    }
}

