/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.api.util;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;

public class ServiceResult {
    private static String translateError(String key, Object ... params) {
        I18nHelper.BeanFactory helper = ComponentAccessor.getI18nHelperFactory();
        JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        return helper.getInstance(jiraAuthenticationContext.getUser()).getText(key, (Object)params);
    }

    public static <T> Either<ErrorCollection, T> ok(T returnedValue) {
        return Either.right(returnedValue);
    }

    public static Either<ErrorCollection, Option<Object>> ok() {
        return Either.right((Object)Option.none());
    }

    public static <T> Either<ErrorCollection, T> error(ErrorCollection.Reason reason, String messageKey, Object ... params) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        errors.addErrorMessage(ServiceResult.translateError(messageKey, params), reason);
        return Either.left((Object)errors);
    }

    public static <T> Either<ErrorCollection, T> error(String fieldId, ErrorCollection.Reason reason, String messageKey, Object ... params) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        errors.addError(fieldId, ServiceResult.translateError(messageKey, params), reason);
        return Either.left((Object)errors);
    }

    public static <T, U> Either<ErrorCollection, T> error(Either<ErrorCollection, U> e) {
        return Either.left((Object)e.left().get());
    }

    public static <T, U> Either<ErrorCollection, T> error(ErrorCollection e) {
        return Either.left((Object)e);
    }
}

