/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.backlog;

import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.JpoDependencyGraph;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class JpoStructureRecursiveImpl
implements JpoDependencyGraph {
    private final BiMap<String, ? extends SchedulingWorkItem> itemMap;

    JpoStructureRecursiveImpl(BiMap<String, ? extends SchedulingWorkItem> map) {
        this.itemMap = map;
    }

    @Override
    public Set<SchedulingWorkItem> getSelfAndInheritedPrerequisites(SchedulingWorkItem item) {
        HashSet prerequisites = Sets.newHashSet();
        if (item == null) {
            return prerequisites;
        }
        List<String> prerequisites1 = item.getPrerequisites();
        if (prerequisites1 != null) {
            prerequisites.addAll(RmIdentifiableUtils.getElementsWithIds(prerequisites1, this.itemMap));
        }
        prerequisites.addAll(this.getSelfAndInheritedPrerequisites((SchedulingWorkItem)this.itemMap.get((Object)item.getParentId())));
        return prerequisites;
    }

    @Override
    public Set<SchedulingWorkItem> getLeafChildrenOfFamilyOf(SchedulingWorkItem item) {
        Set<String> childIds = item.getChildIds();
        if (childIds.isEmpty()) {
            return Sets.newHashSet((Object[])new SchedulingWorkItem[]{item});
        }
        HashSet leaves = Sets.newHashSet();
        Set<? extends SchedulingWorkItem> children = RmIdentifiableUtils.getElementsWithIds(childIds, this.itemMap);
        for (SchedulingWorkItem schedulingWorkItem : children) {
            leaves.addAll(this.getLeafChildrenOfFamilyOf(schedulingWorkItem));
        }
        return leaves;
    }

    static JpoStructureRecursiveImpl create(Collection<? extends SchedulingWorkItem> allWorkItems) {
        BiMap<String, ? extends SchedulingWorkItem> itemMap = RmIdentifiableUtils.createIdMap(allWorkItems);
        return new JpoStructureRecursiveImpl(itemMap);
    }
}

