/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.issuelink;

import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.issuelink.EpicService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.AgileServiceOutcomeException;
import com.atlassian.rm.common.bridges.agile.common.service.BundleServiceServiceResultHandler;
import com.atlassian.rm.common.bridges.agile.issuelink.AgileEpicLinkManagerServiceBridge;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessorProvider;
import com.google.common.collect.Sets;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.agile.issuelink.AgileEpicLinkManagerServiceBridgeImpl")
@SupportedVersions(all=true)
public class AgileEpicLinkManagerServiceBridgeImpl
implements AgileEpicLinkManagerServiceBridge {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final BundleServiceServiceResultHandler serviceResultHandler;

    @Autowired
    AgileEpicLinkManagerServiceBridgeImpl(BundleServiceAccessorProvider bundleServiceAccessorProvider, JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.serviceResultHandler = new BundleServiceServiceResultHandler(bundleServiceAccessorProvider, "com.atlassian.greenhopper.service.issuelink.EpicService");
    }

    @Override
    public void associateIssueWithEpic(final Issue epic, final Issue toAssociate) throws AgileNotAvailableException, AgileServiceOutcomeException {
        this.serviceResultHandler.perform(new BundleServiceServiceResultHandler.Action<EpicService, ServiceResult>(){

            @Override
            public ServiceResult getServiceResult(EpicService epicService) {
                return epicService.addIssuesToEpic(AgileEpicLinkManagerServiceBridgeImpl.this.jiraAuthenticationContext.getUser(), epic, (Set)Sets.newHashSet((Object[])new Issue[]{toAssociate}));
            }
        });
    }

    @Override
    public void removeIssueFromEpic(final Issue toRemove) throws AgileNotAvailableException, AgileServiceOutcomeException {
        this.serviceResultHandler.perform(new BundleServiceServiceResultHandler.Action<EpicService, ServiceResult>(){

            @Override
            public ServiceResult getServiceResult(EpicService epicService) {
                return epicService.removeEpicFromIssues(AgileEpicLinkManagerServiceBridgeImpl.this.jiraAuthenticationContext.getUser(), (Set)Sets.newHashSet((Object[])new Issue[]{toRemove}));
            }
        });
    }
}

