/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.teams;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.entities.people.PlanningMode;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.generator.teams.IResourceConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.ISprintConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.ITeamConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.ResourcePersistency;
import com.radiantminds.roadmap.common.data.generator.teams.SprintPersistency;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAbilityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAbsenceIntervalPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAvailabilityIntervalPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPersonPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPresenceIntervalPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioResourcePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioSprintPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.rest.entities.people.RestTeam;
import java.sql.SQLException;
import java.util.List;

public class TeamPersistency {
    private final PortfolioTeamPersistence peristency;
    private final ResourcePersistency resourcePersistency;
    private final SprintPersistency sprintPersistency;

    public TeamPersistency(PortfolioPersonPersistence personPersistence, PortfolioAbilityPersistence abilityPersistence, PortfolioTeamPersistence teamPersistence, PortfolioResourcePersistence resourcePersistence, PortfolioSprintPersistence sprintPersistence, PortfolioAvailabilityIntervalPersistence availabilityIntervalPersistence, PortfolioPresenceIntervalPersistence presenceIntervalPersistence, PortfolioAbsenceIntervalPersistence absenceIntervalPersistence) {
        this.peristency = teamPersistence;
        this.resourcePersistency = new ResourcePersistency(personPersistence, abilityPersistence, resourcePersistence, availabilityIntervalPersistence, presenceIntervalPersistence, absenceIntervalPersistence);
        this.sprintPersistency = new SprintPersistency(sprintPersistence);
    }

    ITeam persistTeam(ITeamConfiguration configuration, IPlan plan) throws PersistenceException, SQLException {
        RestTeam team = new RestTeam(null, null, null);
        team.setPlan(plan);
        String title = configuration.getTitle();
        team.setTitle(title);
        PlanningMode planningMode = configuration.getPlanningMode();
        team.setPlanningMode(planningMode);
        ITeam persistedTeam = this.peristency.persist(team);
        List resourceConfigurations = Lists.reverse(configuration.getResourceConfigurations());
        for (IResourceConfiguration resourceConfiguration : resourceConfigurations) {
            this.resourcePersistency.persistResource(resourceConfiguration, persistedTeam, plan);
        }
        List sprintConfigurations = Lists.reverse(configuration.getSprintConfigurations());
        for (ISprintConfiguration sprintConfiguration : sprintConfigurations) {
            this.sprintPersistency.persistSprint(sprintConfiguration, persistedTeam);
        }
        return persistedTeam;
    }
}

