/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select;

import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.EstimationDataBlock;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestEstimate;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestWorkItem;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
class EstimationAppender {
    EstimationAppender() {
    }

    void appendEstimations(RestWorkItem item, Set<EstimationDataBlock> estimationDataBlocks) {
        for (EstimationDataBlock estimationDataBlock : estimationDataBlocks) {
            this.handleEstimates(item, estimationDataBlock);
        }
    }

    void handleEstimates(RestWorkItem workItem, EstimationDataBlock estimationData) {
        String targetType = estimationData.getTargetType().getId();
        Boolean replanning = (Boolean)estimationData.getReplanning().orNull();
        Boolean original = (Boolean)estimationData.getOriginal().orNull();
        RestEstimate estimate = new RestEstimate(estimationData.getTargetId(), estimationData.getEstimate());
        estimate.setTargetType(targetType);
        estimate.setReplanning(replanning);
        estimate.setEstimate(estimationData.getEstimate());
        if (original != null && original.booleanValue()) {
            if ("skill".equals(targetType)) {
                workItem.getOriginalEstimates().addSkillEstimate(estimate);
            } else if ("stage".equals(targetType)) {
                workItem.getOriginalEstimates().addStageEstimate(estimate);
            } else {
                workItem.getOriginalEstimates().setTotal(estimate);
            }
        } else if (replanning == null || !replanning.booleanValue()) {
            if ("skill".equals(targetType)) {
                workItem.getCurrentEstimates().addSkillEstimate(estimate);
            } else if ("stage".equals(targetType)) {
                workItem.getCurrentEstimates().addStageEstimate(estimate);
            } else {
                workItem.getCurrentEstimates().setTotal(estimate);
            }
        } else if ("skill".equals(targetType)) {
            workItem.getReplanningEstimates().addSkillEstimate(estimate);
        } else if ("stage".equals(targetType)) {
            workItem.getReplanningEstimates().addStageEstimate(estimate);
        } else {
            workItem.getReplanningEstimates().setTotal(estimate);
        }
    }
}

