/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.port;

import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.port.TranslationException;
import com.radiantminds.roadmap.common.data.persistence.ao.port.XmlExportablePersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.XmlExportablePersistence;
import java.util.Map;

class IdMapper {
    private final Map<Class<?>, Map<String, String>> idMaps = Maps.newHashMap();
    private final Map<Class<?>, Integer> idCounters = Maps.newHashMap();

    public IdMapper(XmlExportablePersistenceIndex index) {
        for (XmlExportablePersistence persistence : index.getPersistenceBeans()) {
            this.idMaps.put(persistence.getDbInterfaceClass(), Maps.newHashMap());
            this.idCounters.put(persistence.getDbInterfaceClass(), 0);
        }
    }

    public String getWithoutMapping(Class<?> aoClazz, String id) {
        Map<String, String> idMap = this.idMaps.get(aoClazz);
        return idMap.get(id);
    }

    public void put(Class<?> aoClazz, String id, String mapped) {
        Map<String, String> idMap = this.idMaps.get(aoClazz);
        idMap.put(id, mapped);
    }

    public String getMappedId(Class<?> aoClazz, String id) {
        Map<String, String> idMap = this.idMaps.get(aoClazz);
        if (!idMap.containsKey(id)) {
            Integer newId = this.idCounters.get(aoClazz) + 1;
            idMap.put(id, String.valueOf(newId));
            this.idCounters.put(aoClazz, newId);
        }
        return idMap.get(id);
    }

    public String getPlanId() throws TranslationException {
        Map<String, String> planMap = this.idMaps.get(AOPlan.class);
        if (planMap.size() != 1) {
            throw new TranslationException("Zero or more than one plan id was mapped. Only single-plan import is supported.");
        }
        return planMap.values().iterator().next();
    }
}

