/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers.extensionlinks;

import com.atlassian.pocketknife.api.logging.Log;
import com.radiantminds.roadmap.common.handlers.extensionlinks.InvalidLinkException;
import javax.annotation.Nonnull;

public interface RemoveExtensionLinkRequest {
    @Nonnull
    public String getLink();

    @Nonnull
    public String getKey();

    public static class Impl
    implements RemoveExtensionLinkRequest {
        private static final Log LOGGER = Log.with(RemoveExtensionLinkRequest.class);
        private final String key;
        private final String link;

        private Impl(String key, String link) {
            this.key = key;
            this.link = link;
        }

        @Override
        public String getLink() {
            return this.link;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public String toString() {
            return "RemoveExtensionLinkRequest.Impl{, link='" + this.link + '\'' + '}';
        }

        public static RemoveExtensionLinkRequest create(String key, String link) throws InvalidLinkException {
            if (key == null) {
                LOGGER.warn("key of link request is null", new Object[0]);
                throw new InvalidLinkException();
            }
            if (link == null) {
                LOGGER.warn("link of link request is null", new Object[0]);
                throw new InvalidLinkException();
            }
            return new Impl(key, link);
        }
    }
}

