/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.solution;

import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IResourceTypeDescription;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IWorkStatistics;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
abstract class WorkStatistics
implements IWorkStatistics {
    private final PlanningUnit planningUnit;
    private final double avgResourceUtilization;
    private final double workLoad;
    private final double availableWork;
    private final PositivePrimitivesMap<IResourceTypeDescription> freeTypes;

    protected WorkStatistics(PlanningUnit planningUnit, double avgResourceUtilization, double workLoad, double availableWork, PositivePrimitivesMap<IResourceTypeDescription> freeTypes) {
        this.planningUnit = planningUnit;
        this.avgResourceUtilization = avgResourceUtilization;
        this.workLoad = workLoad;
        this.availableWork = availableWork;
        this.freeTypes = freeTypes;
    }

    @Override
    public double getAvgResourceUtilization() {
        return this.avgResourceUtilization;
    }

    @Override
    public double getWorkLoad() {
        return this.workLoad;
    }

    @Override
    public double getUtilization() {
        if (this.availableWork <= 0.0) {
            return 1.0;
        }
        return this.workLoad / this.availableWork;
    }

    @Override
    public List<IResourceTypeDescription> getFreeCapacitiesOfResourceTypes() {
        return RmUtils.getReverseOrderWithNumericalValues(this.freeTypes);
    }

    @Override
    public double getAvailableWork() {
        return this.availableWork;
    }

    @Override
    public PositivePrimitivesMap<IResourceTypeDescription> getFreeTypes() {
        return this.freeTypes;
    }

    @Override
    public PlanningUnit getPlanningUnit() {
        return this.planningUnit;
    }
}

