/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimateBlock;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.SyncInformation;
import com.radiantminds.roadmap.common.extensions.issues.IssueSyncData;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestEstimate;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestEstimateBlock;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.PlanInformation;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.PortfolioToJiraSyncConfiguration;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.PortfolioToJiraSyncData;
import com.radiantminds.roadmap.jira.common.components.utils.TimeTracking;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.JiraAgileCustomFieldData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class PortfolioToJiraSyncDataProvider {
    private final ApplicationProperties applicationProperties;
    private final PortfolioWorkItemPersistence workItemPersistence;
    private final PortfolioEstimatePersistence estimatePersistence;

    @Autowired
    public PortfolioToJiraSyncDataProvider(ApplicationProperties applicationProperties, PortfolioWorkItemPersistence workItemPersistence, PortfolioEstimatePersistence estimatePersistence) {
        this.applicationProperties = applicationProperties;
        this.workItemPersistence = workItemPersistence;
        this.estimatePersistence = estimatePersistence;
    }

    public List<PortfolioToJiraSyncData> getSynchronizationData(Iterable<IssueSyncData> issueSyncData, final PlanInformation planInformation, Optional<JiraAgileCustomFieldData> customFieldData) throws SQLException {
        Iterable issuesWithEstimateSyncing;
        boolean syncEstimates = this.shallSyncEstimates(planInformation, customFieldData);
        Iterable filteredSyncData = Iterables.filter(issueSyncData, IssueSyncData.isPersisted());
        if (!(filteredSyncData = Iterables.filter((Iterable)filteredSyncData, (Predicate)new PropertySynchronizationFilterPredicate(planInformation.getSyncConfiguration(), syncEstimates))).iterator().hasNext()) {
            return Lists.newArrayList();
        }
        final Map<String, SyncInformation> syncInformationsByID = this.workItemPersistence.getSyncInformation(PortfolioToJiraSyncDataProvider.toIDs(filteredSyncData), planInformation.getSyncConfiguration().createAcceptedWorkItemTypes());
        if (!(filteredSyncData = Iterables.filter((Iterable)filteredSyncData, (Predicate)new Predicate<IssueSyncData>(){

            public boolean apply(IssueSyncData data) {
                return syncInformationsByID.containsKey(data.getId());
            }
        })).iterator().hasNext()) {
            return Lists.newArrayList();
        }
        Map<Object, Object> remainingAndOriginalEstimates = Maps.newHashMap();
        if (syncEstimates && (issuesWithEstimateSyncing = Iterables.filter((Iterable)filteredSyncData, (Predicate)new Predicate<IssueSyncData>(){

            public boolean apply(IssueSyncData issueSyncData) {
                return issueSyncData.isSyncEstimate();
            }
        })).iterator().hasNext()) {
            remainingAndOriginalEstimates = this.estimatePersistence.getRemainingAndOriginalEstimates(PortfolioToJiraSyncDataProvider.toIDs(issuesWithEstimateSyncing));
            this.fillZeroRemainingEstimates(remainingAndOriginalEstimates);
        }
        final HashMap finalRemainingAndOriginalEstimates = remainingAndOriginalEstimates;
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)filteredSyncData, (Function)new Function<IssueSyncData, PortfolioToJiraSyncData>(){

            public PortfolioToJiraSyncData apply(IssueSyncData issueSyncData) {
                return PortfolioToJiraSyncData.create(planInformation.getSyncConfiguration(), issueSyncData, (Map)finalRemainingAndOriginalEstimates.get(issueSyncData.getId()), (SyncInformation)syncInformationsByID.get(issueSyncData.getId()));
            }
        }));
    }

    private boolean shallSyncEstimates(PlanInformation planInformation, Optional<JiraAgileCustomFieldData> customFieldData) {
        if (planInformation.getSyncConfiguration().isSyncEstimates()) {
            if (planInformation.getPlanningUnit() == PlanningUnit.STORY_POINTS) {
                return customFieldData.isPresent();
            }
            return TimeTracking.isEnabled(this.applicationProperties);
        }
        return false;
    }

    private void fillZeroRemainingEstimates(Map<String, Map<DataMode, IEstimateBlock>> remainingAndOriginalEstimates) {
        for (String workItemId : remainingAndOriginalEstimates.keySet()) {
            Map<DataMode, IEstimateBlock> estimates = remainingAndOriginalEstimates.get(workItemId);
            if (estimates.get((Object)DataMode.Default) != null) continue;
            RestEstimateBlock estimateBlock = new RestEstimateBlock();
            estimateBlock.setTotal(new RestEstimate(0.0));
            estimates.put(DataMode.Default, estimateBlock);
        }
    }

    private static Set<String> toIDs(Iterable<IssueSyncData> issueSyncDatas) {
        return Sets.newHashSet((Iterable)Iterables.transform(issueSyncDatas, IssueSyncData.toId()));
    }

    static class PropertySynchronizationFilterPredicate
    implements Predicate<IssueSyncData> {
        private final PortfolioToJiraSyncConfiguration syncConfiguration;
        private final boolean canSyncEstimates;

        public PropertySynchronizationFilterPredicate(PortfolioToJiraSyncConfiguration syncConfiguration, boolean canSyncEstimates) {
            this.syncConfiguration = syncConfiguration;
            this.canSyncEstimates = canSyncEstimates;
        }

        public boolean apply(IssueSyncData data) {
            return this.syncConfiguration.isSyncTitle() && data.getTitle().isPresent() || this.syncConfiguration.isSyncDescription() && data.getDescription().isPresent() || this.canSyncEstimates && data.isSyncEstimate();
        }
    }
}

