/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.common;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.ResourceType;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositiveTroveMap;
import com.google.common.base.Optional;
import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingAbility;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingPerson;
import com.radiantminds.roadmap.common.data.entities.skills.SchedulingSkill;
import com.radiantminds.roadmap.common.data.entities.skills.SchedulingStage;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.IResourceTypeMapping;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SupplyFactorMapCreator {
    private static final Log LOGGER = Log.with(SupplyFactorMapCreator.class);
    static final float STANDARD_FACTOR = 1.0f;

    public Optional<ImmutableNonEmptyPositivePrimitivesMap<IResourceType>> createSupplyMap(SchedulingPerson person, IResourceTypeMapping resourceTypeMapping) {
        BiMap<SchedulingStage, IResourceType> stageTypeMapping;
        LOGGER.debug("create supply map for person: %s", person);
        HashMap supplyMap = Maps.newHashMap();
        if (resourceTypeMapping.isEmpty()) {
            supplyMap.put(ResourceType.DUMMY_TYPE, Float.valueOf(1.0f));
            return ImmutableNonEmptyPositiveTroveMap.tryCreate(supplyMap);
        }
        BiMap<SchedulingSkill, IResourceType> skillToTypeBiMap = resourceTypeMapping.getSkillTypeMapping();
        for (Map.Entry entry : skillToTypeBiMap.entrySet()) {
            Double abilityValue;
            float workFactor;
            SchedulingSkill skill = (SchedulingSkill)entry.getKey();
            Optional<? extends SchedulingAbility> abilityForSkill = person.getAbilityForSkill(skill.getId());
            if (!abilityForSkill.isPresent() || !((workFactor = this.getWorkFactor(abilityValue = ((SchedulingAbility)abilityForSkill.get()).getAbilityValue())) > 0.0f)) continue;
            supplyMap.put(skillToTypeBiMap.get((Object)skill), Float.valueOf(workFactor));
        }
        BiMap<SchedulingStage, IResourceType> stageToTypeBiMap = stageTypeMapping = resourceTypeMapping.getStageTypeMapping();
        for (Map.Entry entry : stageToTypeBiMap.entrySet()) {
            Double abilityValue;
            float workFactor;
            SchedulingStage stage = (SchedulingStage)entry.getKey();
            Optional<? extends SchedulingAbility> abilityForStage = person.getAbilityForStage(stage.getId());
            if (!abilityForStage.isPresent() || !((workFactor = this.getWorkFactor(abilityValue = ((SchedulingAbility)abilityForStage.get()).getAbilityValue())) > 0.0f)) continue;
            supplyMap.put(stageToTypeBiMap.get((Object)stage), Float.valueOf(workFactor));
        }
        LOGGER.debug("created supply factor map: %s", RmUtils.toString(supplyMap));
        return ImmutableNonEmptyPositiveTroveMap.tryCreate(supplyMap);
    }

    private float getWorkFactor(Double abilityValue) {
        if (abilityValue == null || abilityValue <= 0.0) {
            return 0.0f;
        }
        return 1.0f;
    }
}

