/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ActivityAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.IndexedOverbookableResourceSkillVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.OverbookedActivityAssignmentProblemVariables;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.OverbookedWorkDistributionVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.HasIndex;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.math.IntMath;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DistributedOverbookedActivityAssignmentProblemVariables {
    private final OverbookedActivityAssignmentProblemVariables wrapped;
    private final Map<Set<Integer>, List<OverbookedWorkDistributionVariable>> distributionVariables;

    private DistributedOverbookedActivityAssignmentProblemVariables(OverbookedActivityAssignmentProblemVariables wrapped, Map<Set<Integer>, List<OverbookedWorkDistributionVariable>> distributionVariables) {
        this.wrapped = wrapped;
        this.distributionVariables = distributionVariables;
    }

    Set<IndexedOverbookableResourceSkillVariable> getOverbookWorkVariables(final int resource) {
        return Sets.filter(this.wrapped.getOverbookWorkVariables(), (Predicate)new Predicate<IndexedOverbookableResourceSkillVariable>(){

            public boolean apply(IndexedOverbookableResourceSkillVariable variable) {
                return variable.getResource() == resource;
            }
        });
    }

    static DistributedOverbookedActivityAssignmentProblemVariables create(ActivityAssignmentProblem problem) {
        OverbookedActivityAssignmentProblemVariables wrappedProblem = OverbookedActivityAssignmentProblemVariables.create(problem);
        return new DistributedOverbookedActivityAssignmentProblemVariables(wrappedProblem, DistributedOverbookedActivityAssignmentProblemVariables.createDistributionVariables(wrappedProblem));
    }

    private static Map<Set<Integer>, List<OverbookedWorkDistributionVariable>> createDistributionVariables(OverbookedActivityAssignmentProblemVariables problem) {
        if (problem.getResources() <= 1) {
            return Collections.emptyMap();
        }
        HashMap variables = Maps.newHashMapWithExpectedSize((int)IntMath.binomial((int)problem.getResources(), (int)2));
        for (int r1 = 0; r1 < problem.getResources() - 1; ++r1) {
            for (int r2 = r1 + 1; r2 < problem.getResources(); ++r2) {
                variables.put(Sets.newHashSet((Object[])new Integer[]{r1, r2}), Lists.newArrayList((Object[])new OverbookedWorkDistributionVariable[]{new OverbookedWorkDistributionVariable(problem.getVariableCount() + variables.size()), new OverbookedWorkDistributionVariable(problem.getVariableCount() + variables.size() + 1)}));
            }
        }
        return variables;
    }

    int getVariableCount() {
        return this.wrapped.getVariableCount() + this.distributionVariables.size() * 2;
    }

    int getResources() {
        return this.wrapped.getResources();
    }

    int getSkills() {
        return this.wrapped.getSkills();
    }

    Set<? extends HasIndex> getSkillVariables(int s) {
        return this.wrapped.getSkillVariables(s);
    }

    double getDemand(int s) {
        return this.wrapped.getDemand(s);
    }

    Set<? extends HasIndex> getResourceVariables(int r) {
        return this.wrapped.getResourceVariables(r);
    }

    double getAvailability(int r) {
        return this.wrapped.getAvailability(r);
    }

    List<IndexedOverbookableResourceSkillVariable> getWorkVariables() {
        return this.wrapped.getVariables();
    }

    Set<IndexedOverbookableResourceSkillVariable> getNonOverbookWorkVariables() {
        return this.wrapped.getNonOverbookWorkVariables();
    }

    List<OverbookedWorkDistributionVariable> getOverbookDistributionVariables(int r1, int r2) {
        return this.distributionVariables.get(Sets.newHashSet((Object[])new Integer[]{r1, r2}));
    }

    Set<OverbookedWorkDistributionVariable> getOverbookDistributionVariables() {
        return RmUtils.mergeToSet(this.distributionVariables.values());
    }
}

