/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.ITeamVelocityFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkSlotFunction;
import com.atlassian.rm.jpo.scheduling.util.function.IImmutableDiscreteStepFunction;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AdjustedGroupPointsResourceSupplyFunction
implements IWorkSlotFunction {
    private final IWorkSlotFunction resourceAvailabilityFunction;
    private final ITeamVelocityFunction teamVelocityFunction;
    private final WorkSlotsDefinition workSlotsDefinition;
    private final IImmutableDiscreteStepFunction defautlTeamAvailability;

    public AdjustedGroupPointsResourceSupplyFunction(IWorkSlotFunction resourceAvailabilityFunction, IImmutableDiscreteStepFunction defaultTeamAvailability, ITeamVelocityFunction teamVelocityFunction, WorkSlotsDefinition workSlotsDefinition) {
        this.resourceAvailabilityFunction = resourceAvailabilityFunction;
        this.defautlTeamAvailability = defaultTeamAvailability;
        this.teamVelocityFunction = teamVelocityFunction;
        this.workSlotsDefinition = workSlotsDefinition;
    }

    @Override
    public float getUnassignedWorkInWorkSlot(int slotIndex) {
        if (this.workSlotsDefinition.isRestrictedWorkSlot(slotIndex)) {
            return 0.0f;
        }
        float resourceAvailable = this.resourceAvailabilityFunction.getUnassignedWorkInWorkSlot(slotIndex);
        if (resourceAvailable == 0.0f) {
            return 0.0f;
        }
        float availabilityFactor = resourceAvailable / this.defautlTeamAvailability.getAt(slotIndex);
        float teamVelocity = this.teamVelocityFunction.getVelocity(slotIndex);
        return teamVelocity * availabilityFactor;
    }

    @Override
    public float getRestrictedAvailability(int slotIndex) {
        float resourceAvailable = this.resourceAvailabilityFunction.getRestrictedAvailability(slotIndex);
        if (resourceAvailable == 0.0f) {
            return 0.0f;
        }
        float availabilityFactor = resourceAvailable / this.defautlTeamAvailability.getAt(slotIndex);
        float teamVelocity = this.teamVelocityFunction.getVelocity(slotIndex);
        return teamVelocity * availabilityFactor;
    }

    @Override
    public int getFirstRegularTimeStep() {
        return this.resourceAvailabilityFunction.getFirstRegularTimeStep();
    }

    @Override
    public boolean isPositiveEnding() {
        return this.resourceAvailabilityFunction.isPositiveEnding() && this.teamVelocityFunction.isPositiveEnding();
    }
}

