/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.integrity.rank;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.ISortable;
import com.radiantminds.roadmap.common.data.integrity.DatabaseIntegrityConfiguration;
import com.radiantminds.roadmap.common.data.integrity.rank.SortOrderExistenceIntegrityChecker;
import com.radiantminds.roadmap.common.data.integrity.rank.WorkItemOrderRangeIdentifierIntegrityChecker;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DatabaseIntegrityConfiguration(requires={WorkItemOrderRangeIdentifierIntegrityChecker.class})
public class WorkItemSortOrderExistenceIntegrityChecker
extends SortOrderExistenceIntegrityChecker {
    private static final Log LOGGER = Log.with(WorkItemSortOrderExistenceIntegrityChecker.class);

    @Autowired
    public WorkItemSortOrderExistenceIntegrityChecker(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    @Override
    protected List<Class<? extends ISortable>> getApplicableTables() {
        return Lists.newArrayList((Object[])new Class[]{AOWorkItem.class});
    }

    @Override
    protected void checkClassForRankIntegrity(Connection connection, String planId, Class<? extends ISortable> clazz) throws SQLException {
        Set<String> idsWithoutSortOrders = this.getIdsWithoutSortOrdersThatShouldHaveSortOrders(clazz, planId, connection);
        if (idsWithoutSortOrders.size() > 0) {
            for (String id : idsWithoutSortOrders) {
                LOGGER.warn("Found rank integrity issue: ID %s in table %s has no sort order.", id, clazz);
            }
            this.setSortOrderToZero(clazz, connection, idsWithoutSortOrders);
            LOGGER.info("Set sort order of broken items to zero.", new Object[0]);
        }
    }

    private Set<String> getIdsWithoutSortOrdersThatShouldHaveSortOrders(final Class<? extends ISortable> table, final String planId, Connection connection) throws SQLException {
        return this.sql(new IQuery<Set<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(table, "t").withTable(table, "ti").select().colId("t").from("t").where().col("t", "sortOrder").isNull().and().col("t", "aoPlan").eq().numeric(planId).and().raw("(").select().raw("COUNT(*)").from("ti").where().col("ti", "aoParent").eq().colId("t").raw(")").eq().numeric(0);
            }

            @Override
            public Set<String> handleResult(ResultSet result) throws Exception {
                HashSet ids = Sets.newHashSet();
                while (result.next()) {
                    ids.add(BaseAOPersistenceSQL.getString(result, 1));
                }
                return ids;
            }
        }, connection, false);
    }
}

