/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.plugins.jira.utils;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.plugins.jira.utils.RecentPlansProvider;
import com.radiantminds.plugins.jira.utils.RecentlyVisited;
import com.radiantminds.plugins.jira.utils.UserPropertyManagerWrapper;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.MethodRule;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;

public class RecentPlansProviderTest {
    @Rule
    public final MethodRule mockitoRule = MockitoJUnit.rule();
    @Mock
    private UserPropertyManagerWrapper userPropertyManagerWrapper;
    @Mock
    private PortfolioPlanPersistence portfolioPlanPersistence;
    @InjectMocks
    private RecentPlansProvider recentPlansProvider;

    @Test
    public void testMigrateRecentPlans() throws Exception {
        Mockito.when((Object)this.portfolioPlanPersistence.listAllAvailablePlanIds()).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"2", "5"}));
        Mockito.when((Object)this.userPropertyManagerWrapper.getStrings("com.radiantminds.roadmaps-jira.plans.recent.json")).thenReturn((Object)Lists.newArrayList());
        Mockito.when((Object)this.userPropertyManagerWrapper.getStrings("com.radiantminds.roadmaps-jira.plans.recent")).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"1", "2", "3-2", "4-2", "5", "6-2"}));
        List addResult = this.recentPlansProvider.add(30L);
        Assert.assertEquals((long)6L, (long)addResult.size());
        Assert.assertEquals((long)30L, (long)((RecentlyVisited)addResult.get(0)).getId());
        Assert.assertEquals((long)2L, (long)((RecentlyVisited)addResult.get(1)).getId());
        Assert.assertEquals((long)3L, (long)((RecentlyVisited)addResult.get(2)).getId());
        Assert.assertEquals((long)4L, (long)((RecentlyVisited)addResult.get(3)).getId());
        Assert.assertEquals((long)5L, (long)((RecentlyVisited)addResult.get(4)).getId());
        Assert.assertEquals((long)6L, (long)((RecentlyVisited)addResult.get(5)).getId());
        Assert.assertEquals((Object)Optional.absent(), (Object)((RecentlyVisited)addResult.get(0)).getScenarioId());
        Assert.assertEquals((Object)Optional.absent(), (Object)((RecentlyVisited)addResult.get(1)).getScenarioId());
        Assert.assertEquals((Object)Optional.absent(), (Object)((RecentlyVisited)addResult.get(2)).getScenarioId());
        Assert.assertEquals((Object)Optional.absent(), (Object)((RecentlyVisited)addResult.get(3)).getScenarioId());
        Assert.assertEquals((Object)Optional.absent(), (Object)((RecentlyVisited)addResult.get(4)).getScenarioId());
        Assert.assertEquals((Object)Optional.absent(), (Object)((RecentlyVisited)addResult.get(5)).getScenarioId());
        Assert.assertEquals((Object)RecentlyVisited.EntityType.CLASSIC_PLAN, (Object)((RecentlyVisited)addResult.get(0)).getEntityType());
        Assert.assertEquals((Object)RecentlyVisited.EntityType.CLASSIC_PLAN, (Object)((RecentlyVisited)addResult.get(1)).getEntityType());
        Assert.assertEquals((Object)RecentlyVisited.EntityType.LIVE_PLAN, (Object)((RecentlyVisited)addResult.get(2)).getEntityType());
        Assert.assertEquals((Object)RecentlyVisited.EntityType.LIVE_PLAN, (Object)((RecentlyVisited)addResult.get(3)).getEntityType());
        Assert.assertEquals((Object)RecentlyVisited.EntityType.CLASSIC_PLAN, (Object)((RecentlyVisited)addResult.get(4)).getEntityType());
        Assert.assertEquals((Object)RecentlyVisited.EntityType.LIVE_PLAN, (Object)((RecentlyVisited)addResult.get(5)).getEntityType());
    }

    @Test
    public void testAddRecentPlan() throws Exception {
        Mockito.when((Object)this.portfolioPlanPersistence.listAllAvailablePlanIds()).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"2", "3", "5", "7"}));
        Mockito.when((Object)this.userPropertyManagerWrapper.getStrings("com.radiantminds.roadmaps-jira.plans.recent")).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"11", "22", "33", "44", "55", "66"}));
        Mockito.when((Object)this.userPropertyManagerWrapper.getStrings("com.radiantminds.roadmaps-jira.plans.recent.json")).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"{\"planId\":1, \"scenarioId\":7 , \"jpoVersion\":2}", "{\"planId\":2,                    \"jpoVersion\":2}", "{\"planId\":3, \"scenarioId\":9 , \"jpoVersion\":2}", "{\"planId\":4,                    \"jpoVersion\":1}", "{\"planId\":5, \"scenarioId\":11, \"jpoVersion\":2}", "{\"planId\":5, \"scenarioId\":11, \"jpoVersion\":1}", "{\"planId\":6, \"scenarioId\":12, \"jpoVersion\":2}"}));
        List addResult = this.recentPlansProvider.add(30L);
        ((UserPropertyManagerWrapper)Mockito.verify((Object)this.userPropertyManagerWrapper)).setStrings((String)ArgumentMatchers.eq((Object)"com.radiantminds.roadmaps-jira.plans.recent.json"), ArgumentMatchers.anyIterable());
        Assert.assertEquals((long)7L, (long)addResult.size());
        Assert.assertEquals((long)30L, (long)((RecentlyVisited)addResult.get(0)).getId());
        Assert.assertEquals((long)1L, (long)((RecentlyVisited)addResult.get(1)).getId());
        Assert.assertEquals((long)2L, (long)((RecentlyVisited)addResult.get(2)).getId());
        Assert.assertEquals((long)3L, (long)((RecentlyVisited)addResult.get(3)).getId());
        Assert.assertEquals((long)5L, (long)((RecentlyVisited)addResult.get(4)).getId());
        Assert.assertEquals((long)5L, (long)((RecentlyVisited)addResult.get(5)).getId());
        Assert.assertEquals((long)6L, (long)((RecentlyVisited)addResult.get(6)).getId());
        Assert.assertEquals((Object)Optional.absent(), (Object)((RecentlyVisited)addResult.get(0)).getScenarioId());
        Assert.assertEquals((Object)Optional.of((Object)7L), (Object)((RecentlyVisited)addResult.get(1)).getScenarioId());
        Assert.assertEquals((Object)Optional.absent(), (Object)((RecentlyVisited)addResult.get(2)).getScenarioId());
        Assert.assertEquals((Object)Optional.of((Object)9L), (Object)((RecentlyVisited)addResult.get(3)).getScenarioId());
        Assert.assertEquals((Object)Optional.of((Object)11L), (Object)((RecentlyVisited)addResult.get(4)).getScenarioId());
        Assert.assertEquals((Object)Optional.of((Object)11L), (Object)((RecentlyVisited)addResult.get(5)).getScenarioId());
        Assert.assertEquals((Object)Optional.of((Object)12L), (Object)((RecentlyVisited)addResult.get(6)).getScenarioId());
        Assert.assertEquals((Object)RecentlyVisited.EntityType.CLASSIC_PLAN, (Object)((RecentlyVisited)addResult.get(0)).getEntityType());
        Assert.assertEquals((Object)RecentlyVisited.EntityType.LIVE_PLAN, (Object)((RecentlyVisited)addResult.get(1)).getEntityType());
        Assert.assertEquals((Object)RecentlyVisited.EntityType.LIVE_PLAN, (Object)((RecentlyVisited)addResult.get(2)).getEntityType());
        Assert.assertEquals((Object)RecentlyVisited.EntityType.LIVE_PLAN, (Object)((RecentlyVisited)addResult.get(3)).getEntityType());
        Assert.assertEquals((Object)RecentlyVisited.EntityType.LIVE_PLAN, (Object)((RecentlyVisited)addResult.get(4)).getEntityType());
        Assert.assertEquals((Object)RecentlyVisited.EntityType.CLASSIC_PLAN, (Object)((RecentlyVisited)addResult.get(5)).getEntityType());
        Assert.assertEquals((Object)RecentlyVisited.EntityType.LIVE_PLAN, (Object)((RecentlyVisited)addResult.get(6)).getEntityType());
    }

    @Test
    public void testObsoletePropertyHoldsJson() {
        String legacy = "{\"planId\":2,\"jpoVersion\":1,\"timestamp\":1484905678763}";
        Mockito.when((Object)this.userPropertyManagerWrapper.getStrings("com.radiantminds.roadmaps-jira.plans.recent")).thenReturn((Object)Lists.newArrayList((Object[])new String[]{legacy}));
        List result = this.recentPlansProvider.getRecentlyVisitedPlans();
        Assert.assertEquals((Object)new RecentlyVisited(Long.valueOf(2L), Optional.absent(), RecentlyVisited.EntityType.CLASSIC_PLAN), result.get(0));
    }
}

