/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.persistence;

import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.rm.common.pkqdsl.legacy.AbstractConnectionProvider;
import com.atlassian.rm.common.pkqdsl.legacy.ConnectionPrimer;
import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.persistence.JiraConnectionProviderImpl")
public class JiraConnectionProviderImpl
extends AbstractConnectionProvider {
    @Autowired
    public JiraConnectionProviderImpl(ConnectionPrimer connectionPrimer) {
        super(connectionPrimer);
    }

    @Override
    protected Connection getConnectionImpl(boolean autoCommit) {
        DefaultOfBizConnectionFactory instance = this.getDefaultOfBizConnectionFactory();
        this.log().debug("Getting a connection with auto-commit '" + autoCommit + "' using a DefaultOfBizConnectionFactory");
        try {
            Connection connection = instance.getConnection();
            connection.setAutoCommit(autoCommit);
            this.log().debug("Got connection with auto-commit '" + autoCommit + "'");
            return connection;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private DefaultOfBizConnectionFactory getDefaultOfBizConnectionFactory() {
        return DefaultOfBizConnectionFactory.getInstance();
    }
}

