/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.plugins.jira.utils;

import com.google.common.base.Optional;
import javax.validation.constraints.NotNull;

public class RecentlyVisited
implements Comparable {
    private Long id;
    private Optional<Long> scenarioId;
    private EntityType entityType;

    public RecentlyVisited(Long id, Optional<Long> scenarioId, EntityType entityType) {
        this.id = id;
        this.scenarioId = scenarioId;
        this.entityType = entityType;
    }

    public RecentlyVisited(Long id, EntityType entityType) {
        this(id, (Optional<Long>)Optional.absent(), entityType);
    }

    @NotNull
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Optional<Long> getScenarioId() {
        return this.scenarioId;
    }

    public void setScenarioId(Optional<Long> scenarioId) {
        this.scenarioId = scenarioId;
    }

    @NotNull
    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return 0;
        }
        RecentlyVisited that = (RecentlyVisited)o;
        if (this.entityType == null || that.entityType == null || this.id == null || that.id == null) {
            return 0;
        }
        int jpoVersionCompare = this.entityType.compareTo(that.getEntityType());
        if (jpoVersionCompare == 0) {
            return this.id.compareTo(that.id);
        }
        return jpoVersionCompare;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecentlyVisited that = (RecentlyVisited)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.entityType != null ? this.entityType.equals((Object)that.entityType) : that.entityType == null;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.entityType != null ? this.entityType.hashCode() : 0);
        return result;
    }

    public static enum EntityType {
        CLASSIC_PLAN(1),
        LIVE_PLAN(2),
        PROGRAM(3),
        SIMPLE_PLAN(4);

        int typeId;

        public static EntityType fromInteger(int id) {
            EntityType entityType;
            switch (id) {
                case 1: {
                    entityType = CLASSIC_PLAN;
                    break;
                }
                case 2: {
                    entityType = LIVE_PLAN;
                    break;
                }
                case 3: {
                    entityType = PROGRAM;
                    break;
                }
                case 4: {
                    entityType = SIMPLE_PLAN;
                    break;
                }
                default: {
                    throw new RuntimeException("EntityType not found! " + id);
                }
            }
            return entityType;
        }

        int getTypeId() {
            return this.typeId;
        }

        private EntityType(int typeId) {
            this.typeId = typeId;
        }
    }
}

