/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.api.plugins;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.BridgeManager;
import com.atlassian.rm.common.bridges.api.FeatureAccessor;
import com.atlassian.rm.common.bridges.api.NoBridgeAvailableException;
import com.atlassian.rm.common.bridges.api.Version;
import com.atlassian.rm.common.bridges.api.plugins.PluginAvailabilityChecker;
import com.atlassian.rm.common.bridges.api.plugins.PluginNotAvailableException;
import com.atlassian.rm.common.bridges.api.plugins.PluginVersionProxy;
import com.google.common.base.Optional;
import java.lang.ref.WeakReference;
import java.util.List;

public abstract class PluginVersionAwareSpringProxy<TSpringInterface>
implements PluginVersionProxy<TSpringInterface> {
    private static final Log LOGGER = Log.with(PluginVersionAwareSpringProxy.class);
    private final BridgeManager<TSpringInterface> bridgeManager;
    private final PluginAvailabilityChecker pluginAvailabilityChecker;
    private final Class<TSpringInterface> clazz;
    private volatile WeakReference<TSpringInterface> bridgeReference = new WeakReference<Object>(null);

    protected PluginVersionAwareSpringProxy(String pluginKey, Optional<Version> minimumVersion, PluginAccessor pluginAccessor, List<TSpringInterface> beans, Class<TSpringInterface> clazz) {
        this(pluginKey, minimumVersion, pluginAccessor, beans, clazz, (Optional<FeatureAccessor>)Optional.absent());
    }

    protected PluginVersionAwareSpringProxy(String pluginKey, Optional<Version> minimumVersion, PluginAccessor pluginAccessor, List<TSpringInterface> beans, Class<TSpringInterface> clazz, Optional<FeatureAccessor> featureAccessor) {
        this.bridgeManager = new BridgeManager<TSpringInterface>(beans, featureAccessor);
        this.pluginAvailabilityChecker = new PluginAvailabilityChecker(pluginKey, minimumVersion, pluginAccessor);
        this.clazz = clazz;
    }

    @Override
    public TSpringInterface get() throws PluginNotAvailableException {
        Object bridge = this.bridgeReference.get();
        if (null == bridge) {
            bridge = this.load();
            this.bridgeReference = new WeakReference<TSpringInterface>(bridge);
        }
        return (TSpringInterface)bridge;
    }

    private TSpringInterface load() throws PluginNotAvailableException {
        String pluginVersionString = this.pluginAvailabilityChecker.getVersionIfAvailable();
        if (pluginVersionString == null) {
            throw new PluginNotAvailableException();
        }
        Version pluginVersion = new Version(pluginVersionString);
        Optional<TSpringInterface> supportedBridge = this.bridgeManager.getSupportedBridge(pluginVersion);
        if (supportedBridge.isPresent()) {
            Object bridge = supportedBridge.get();
            LOGGER.debug(String.format("Bridge implementation %s chosen for API version %s.", bridge.getClass(), pluginVersion.toString()), new Object[0]);
            return (TSpringInterface)bridge;
        }
        LOGGER.warn(String.format("No bridge implementation for %s available for API version %s.", this.clazz.toString(), pluginVersion.toString()), new Object[0]);
        throw new NoBridgeAvailableException(pluginVersion, this.clazz);
    }
}

