/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotItemAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivity;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivitySet;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IStageTask;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IUnstructuredItem;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class PeriodActivityMapping {
    private final List<IStageTask> stageTasks;
    private final List<IActivity> activitiesToSchedule;
    private final List<IUnstructuredItem> unstructuredItems;
    private final Map<IActivity, IActivitySet> activitiesToActivitySets;
    private final Map<IStageTask, IActivitySet> taskToActivitySets;

    PeriodActivityMapping(List<IStageTask> stageTasks, List<IActivity> activitiesToSchedule, List<IUnstructuredItem> unstructuredItems, Map<IActivity, IActivitySet> activitiesToActivitySets, Map<IStageTask, IActivitySet> taskToActivitySets) {
        this.stageTasks = stageTasks;
        this.activitiesToSchedule = activitiesToSchedule;
        this.unstructuredItems = unstructuredItems;
        this.activitiesToActivitySets = activitiesToActivitySets;
        this.taskToActivitySets = taskToActivitySets;
    }

    static PeriodActivityMapping create(Set<FixedSlotItemAssignmentProblem> assignmentProblemsForSlot) {
        List<FixedSlotItemAssignmentProblem> sortedProblems = RmIdentifiableUtils.sortById(assignmentProblemsForSlot);
        ArrayList stageTasks = Lists.newArrayList();
        ArrayList activitiesToSchedule = Lists.newArrayList();
        ArrayList unstructured = Lists.newArrayList();
        HashMap activitiesToActivitySets = Maps.newHashMap();
        HashMap taskToActivitySets = Maps.newHashMap();
        for (FixedSlotItemAssignmentProblem sortedProblem : sortedProblems) {
            IProcessingItem item = sortedProblem.getItem();
            if (item instanceof IActivitySet) {
                IActivitySet activitySet = (IActivitySet)item;
                for (IActivity activity : activitySet.getActivities()) {
                    stageTasks.addAll(activity.getStageTasks());
                    for (IStageTask task : activity.getStageTasks()) {
                        taskToActivitySets.put(task, activitySet);
                    }
                    if (activity.getPositiveTypeAmounts().isEmpty()) continue;
                    activitiesToSchedule.add(activity);
                    activitiesToActivitySets.put(activity, activitySet);
                }
                continue;
            }
            unstructured.add((IUnstructuredItem)item);
        }
        return new PeriodActivityMapping(stageTasks, activitiesToSchedule, unstructured, activitiesToActivitySets, taskToActivitySets);
    }

    int getPeriodActivities() {
        return this.stageTasks.size() + this.activitiesToSchedule.size() + this.unstructuredItems.size();
    }

    List<IStageTask> getStageTasks() {
        return this.stageTasks;
    }

    IActivitySet getActivitySet(IStageTask stageTask) {
        return this.taskToActivitySets.get(stageTask);
    }

    List<IActivity> getActivities() {
        return this.activitiesToSchedule;
    }

    IProcessingItem getActivitySet(IActivity activity) {
        return this.activitiesToActivitySets.get(activity);
    }

    List<IUnstructuredItem> getUnstructuredItems() {
        return this.unstructuredItems;
    }
}

