/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.teams;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.skills.ISkill;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.generator.GeneratorUtils;
import com.radiantminds.roadmap.common.data.generator.teams.IAbilityConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.IAbilityPersistency;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAbilityPersistence;
import java.sql.SQLException;
import java.util.List;

public class AbilityPersistency
implements IAbilityPersistency {
    private final PortfolioAbilityPersistence persistence;

    public AbilityPersistency(PortfolioAbilityPersistence abilityPersistence) {
        this.persistence = abilityPersistence;
    }

    @Override
    public void persistAbility(IAbilityConfiguration abilityConfiguration, IPerson person, IPlan plan) throws SQLException {
        List<IStage> stages;
        String personId = person.getId();
        Double value = abilityConfiguration.getValue();
        String title = abilityConfiguration.getTitle();
        Optional<IStage> abilityStage = GeneratorUtils.tryFindWithTitle(title, stages = plan.getStages());
        if (abilityStage.isPresent()) {
            this.persistence.setAbility(personId, "stage", ((IStage)abilityStage.get()).getId(), value);
        } else {
            ISkill skill = this.getSkillWithTitle(title, stages);
            this.persistence.setAbility(personId, "skill", skill.getId(), value);
        }
    }

    private ISkill getSkillWithTitle(String title, List<IStage> stages) {
        for (IStage stage : stages) {
            List<ISkill> skills = stage.getSkills();
            for (ISkill skill : skills) {
                if (!title.equals(skill.getTitle())) continue;
                return skill;
            }
        }
        throw new RuntimeException("invalid title: " + title);
    }
}

