/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem;

import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

class WorkItemInheritanceOperator {
    private final PortfolioWorkItemPersistence persistence;

    WorkItemInheritanceOperator(PortfolioWorkItemPersistence persistence) {
        this.persistence = persistence;
    }

    Set<IWorkItem> tryInheritTheme(String themeId, IWorkItem workItem) throws SQLException, PersistenceException {
        return this.tryInheritTheme(themeId, workItem, null);
    }

    void setTheme(String themeId, Set<String> leafIds) throws SQLException {
        for (String leafId : leafIds) {
            this.persistence.setTheme(leafId, themeId);
        }
    }

    private boolean isThemePresent(Set<IWorkItem> leafNodes) throws PersistenceException {
        for (IWorkItem leafNode : leafNodes) {
            if (!this.persistence.tryGetThemeId(leafNode.getId()).isPresent()) continue;
            return true;
        }
        return false;
    }

    private Set<IWorkItem> getLeafNodes(IWorkItem workItem, @Nullable Set<String> inheritanceRestriction) {
        List<? extends IWorkItem> children = workItem.getChildren();
        if (children.isEmpty()) {
            if (inheritanceRestriction == null || inheritanceRestriction.contains(workItem.getId())) {
                return Sets.newHashSet((Object[])new IWorkItem[]{workItem});
            }
            return Sets.newHashSet();
        }
        HashSet leafNodes = Sets.newHashSet();
        for (IWorkItem iWorkItem : children) {
            leafNodes.addAll(this.getLeafNodes(iWorkItem, inheritanceRestriction));
        }
        return leafNodes;
    }

    Set<IWorkItem> tryInheritTheme(String themeId, IWorkItem workItem, @Nullable Set<String> inheritanceRestriction) throws PersistenceException, SQLException {
        Preconditions.checkNotNull((Object)themeId, (Object)"theme must not be null");
        Preconditions.checkNotNull((Object)workItem, (Object)"item must not be null");
        Set<IWorkItem> inheritingLeafNodes = this.getLeafNodes(workItem, inheritanceRestriction);
        if (this.isThemePresent(inheritingLeafNodes)) {
            return Sets.newHashSet();
        }
        this.setTheme(themeId, RmIdentifiableUtils.getIds(inheritingLeafNodes));
        return inheritingLeafNodes;
    }
}

