/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanFullUserAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPluginAdminAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPluginReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPluginUserAccess;
import com.sun.jersey.api.model.AbstractResourceMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class SecurityAnnotations {
    private final Optional<AuthorizedPlanUserAccess> planUserAccess;
    private final Optional<AuthorizedPlanReadAccess> planReadAccess;
    private final Optional<AuthorizedPlanFullUserAccess> planFullUserAccess;
    private final Optional<AuthorizedPluginReadAccess> pluginReadAccess;
    private final Optional<AuthorizedPluginUserAccess> pluginUserAccess;
    private final Optional<AuthorizedPluginAdminAccess> pluginAdminAccess;

    SecurityAnnotations(final AbstractResourceMethod method) {
        this(new MethodDecorator(){

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> clazz) {
                return (T)method.getAnnotation(clazz);
            }
        });
    }

    SecurityAnnotations(final Method method) {
        this(new MethodDecorator(){

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> clazz) {
                return method.getAnnotation(clazz);
            }
        });
    }

    private SecurityAnnotations(MethodDecorator method) {
        this.planUserAccess = Optional.fromNullable((Object)method.getAnnotation(AuthorizedPlanUserAccess.class));
        this.planReadAccess = Optional.fromNullable((Object)method.getAnnotation(AuthorizedPlanReadAccess.class));
        this.planFullUserAccess = Optional.fromNullable((Object)method.getAnnotation(AuthorizedPlanFullUserAccess.class));
        this.pluginReadAccess = Optional.fromNullable((Object)method.getAnnotation(AuthorizedPluginReadAccess.class));
        this.pluginUserAccess = Optional.fromNullable((Object)method.getAnnotation(AuthorizedPluginUserAccess.class));
        this.pluginAdminAccess = Optional.fromNullable((Object)method.getAnnotation(AuthorizedPluginAdminAccess.class));
    }

    public boolean requiresPluginLevelAuth() {
        return this.pluginReadAccess.isPresent() || this.pluginUserAccess.isPresent() || this.pluginAdminAccess.isPresent();
    }

    public Optional<AuthorizedPlanUserAccess> getPlanUserAccess() {
        return this.planUserAccess;
    }

    public Optional<AuthorizedPlanReadAccess> getPlanReadAccess() {
        return this.planReadAccess;
    }

    public Optional<AuthorizedPlanFullUserAccess> getPlanFullUserAccess() {
        return this.planFullUserAccess;
    }

    public Optional<AuthorizedPluginReadAccess> getPluginReadAccess() {
        return this.pluginReadAccess;
    }

    public Optional<AuthorizedPluginUserAccess> getPluginUserAccess() {
        return this.pluginUserAccess;
    }

    public Optional<AuthorizedPluginAdminAccess> getPluginAdminAccess() {
        return this.pluginAdminAccess;
    }

    private static interface MethodDecorator {
        public <T extends Annotation> T getAnnotation(Class<T> var1);
    }
}

