/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.exportimport;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.port.XmlExportablePersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.services.exportimport.ExportServiceHandler;
import com.radiantminds.roadmap.common.rest.utils.async.LongRunningService;
import com.radiantminds.roadmap.common.utils.meta.MetaDataUtils;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/export")
@Component
public class ExportService {
    private final ExportServiceHandler handler;

    @Autowired
    public ExportService(XmlExportablePersistenceIndex index, SecuredInvocationHandlerFactory handlerFactory, ActiveObjectsUtilities activeObjectsUtilities, PortfolioPlanPersistence planPersistence, LongRunningService longRunningService, MetaDataUtils metaDataUtils) {
        this.handler = handlerFactory.createProxy(ExportServiceHandler.class, new ExportServiceHandler.Impl(index, activeObjectsUtilities, longRunningService, metaDataUtils), planPersistence);
    }

    @GET
    @Path(value="{id}")
    public Response exportPlan(@PathParam(value="id") String planId, @QueryParam(value="anonymise") Boolean anonymise, @QueryParam(value="excludeLinks") Boolean excludeLinks) throws Exception {
        return this.handler.exportPlan(EntityContext.from(planId), anonymise, excludeLinks);
    }
}

