/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.scheduling;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IResourceTypeDescription;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="stageOrSkill")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestStageOrSkillId {
    static final String STAGE_TYPE = "stage";
    static final String SKILL_TYPE = "skill";
    @XmlElement
    String id;
    @XmlElement
    String type;

    private RestStageOrSkillId() {
    }

    public RestStageOrSkillId(String id, String type) {
        this.id = id;
        this.type = type;
    }

    public static RestStageOrSkillId create(IResourceType resourceType) {
        return new RestStageOrSkillId(resourceType.getId(), (Boolean)resourceType.isGenerated().or((Object)false) != false ? STAGE_TYPE : SKILL_TYPE);
    }

    public static RestStageOrSkillId create(IResourceTypeDescription toTransform) {
        if (toTransform.isGenerated()) {
            return new RestStageOrSkillId(toTransform.getId(), STAGE_TYPE);
        }
        return new RestStageOrSkillId(toTransform.getId(), SKILL_TYPE);
    }

    public static List<RestStageOrSkillId> create(List<IResourceType> types) {
        ArrayList list = Lists.newArrayList();
        if (types != null) {
            for (IResourceType type : types) {
                list.add(RestStageOrSkillId.create(type));
            }
        }
        return list;
    }
}

