/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.configuration;

import com.radiantminds.roadmap.common.data.entities.plans.INonWorkingDay;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioNonWorkingDaysPersistence;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.plans.RestNonWorkingDay;
import com.radiantminds.roadmap.common.rest.services.common.BaseOperationsService;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/config/nonworkingdays")
@Component
public class NonWorkingDaysService
extends BaseOperationsService<INonWorkingDay, RestNonWorkingDay> {
    @Autowired
    protected NonWorkingDaysService(PortfolioNonWorkingDaysPersistence portfolioNonWorkingDaysPersistence, SecuredInvocationHandlerFactory handlerFactory) {
        super(RestNonWorkingDay.class, portfolioNonWorkingDaysPersistence, handlerFactory);
    }

    @Override
    protected RestNonWorkingDay transform(INonWorkingDay entity, boolean includeReplanningData) {
        return new RestNonWorkingDay(entity);
    }

    @Override
    protected Response update(RestNonWorkingDay source, INonWorkingDay target, boolean allowNull) {
        Long val;
        this.updateCommons(source, target, allowNull);
        if (allowNull || source.getStartDate() != null) {
            val = source.getStartDate();
            if (val == null || val == -1L) {
                val = null;
            }
            target.setStartDate(val);
        }
        if (allowNull || source.getEndDate() != null) {
            val = source.getEndDate();
            if (val == null || val == -1L) {
                val = null;
            }
            target.setEndDate(val);
        }
        return null;
    }
}

