/*
 * Decompiled with CFR 0.152.
 */
package it.com.radiantminds.plugins.jira;

import com.atlassian.rm.common.envtestutils.User;
import com.atlassian.rm.common.envtestutils.WiredIntegrationTestClassRule;
import com.atlassian.rm.common.envtestutils.WiredIntegrationTestMethodRule;
import com.atlassian.rm.common.envtestutils.WiredTestCase;
import com.atlassian.rm.common.envtestutils.WiredTestRuleFactory;
import com.atlassian.rm.common.envtestutils.annotations.Login;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.extensions.users.UserExtension;
import com.radiantminds.roadmap.common.rest.entities.system.RestGroupAndUserListItem;
import java.util.List;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class UserExtensionTest
extends WiredTestCase {
    @Rule
    public final WiredIntegrationTestMethodRule wiredIntegrationTestRule = WiredTestRuleFactory.methodRule();
    @ClassRule
    public static final WiredIntegrationTestClassRule WIRED_INTEGRATION_TEST_CLASS_RULE = WiredTestRuleFactory.classRule();
    private final UserExtension userExtension;

    @Autowired
    public UserExtensionTest(UserExtension userExtension) {
        this.userExtension = userExtension;
    }

    @Test
    @Login(user=User.NON_ADMIN)
    public void testListAllUsers() {
        List users = this.userExtension.listUsers("", (List)Lists.newArrayList(), null);
        Assert.assertEquals((long)2L, (long)users.size());
        List<String> userNames = UserExtensionTest.extractUserNames(users);
        Assert.assertTrue((boolean)userNames.contains(User.ADMIN.getUsername()));
        Assert.assertTrue((boolean)userNames.contains(User.NON_ADMIN.getUsername()));
    }

    @Test
    @Login(user=User.NON_ADMIN)
    public void testListAllUsersCutoff() {
        List usersNoCutoff = this.userExtension.listUsers("", (List)Lists.newArrayList(), null);
        Assert.assertEquals((long)2L, (long)usersNoCutoff.size());
        List usersWithCutoff = this.userExtension.listUsers("", (List)Lists.newArrayList(), Integer.valueOf(1));
        Assert.assertEquals((long)1L, (long)usersWithCutoff.size());
    }

    @Test
    @Login(user=User.NON_ADMIN)
    public void testExclusion() {
        List users = this.userExtension.listUsers("", (List)Lists.newArrayList((Object[])new String[]{User.ADMIN.getUsername()}), null);
        Assert.assertEquals((long)1L, (long)users.size());
        List<String> userNames = UserExtensionTest.extractUserNames(users);
        Assert.assertTrue((boolean)userNames.contains(User.NON_ADMIN.getUsername()));
    }

    @Test
    @Login(user=User.NON_ADMIN)
    public void testListUsersWithQuery() {
        List users = this.userExtension.listUsers("non", (List)Lists.newArrayList(), null);
        Assert.assertEquals((long)1L, (long)users.size());
        List<String> userNames = UserExtensionTest.extractUserNames(users);
        Assert.assertTrue((boolean)userNames.contains(User.NON_ADMIN.getUsername()));
    }

    private static List<String> extractUserNames(List<RestGroupAndUserListItem> users) {
        return Lists.newArrayList((Iterable)Iterables.transform(users, (Function)new Function<RestGroupAndUserListItem, String>(){

            public String apply(RestGroupAndUserListItem restGroupAndUserListItem) {
                return restGroupAndUserListItem.getName();
            }
        }));
    }
}

