/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.service;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.AgileServiceOutcomeException;
import com.atlassian.rm.common.bridges.agile.service.ServiceOutcomeHandler;
import com.atlassian.rm.common.bridges.agile.service.ServiceOutcomeHandlerAction;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessor;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessorProvider;
import com.atlassian.rm.common.bridges.api.plugins.access.ServiceCallback;

public class BundleServiceServiceOutcomeHandler
implements ServiceOutcomeHandler {
    private final BundleServiceAccessorProvider bundleServiceAccessorProvider;
    private final String serviceName;

    public BundleServiceServiceOutcomeHandler(BundleServiceAccessorProvider bundleServiceAccessorProvider, String serviceName) {
        this.bundleServiceAccessorProvider = bundleServiceAccessorProvider;
        this.serviceName = serviceName;
    }

    public BundleServiceServiceOutcomeHandler(BundleServiceAccessorProvider bundleServiceAccessorProvider, Class<?> clazz) {
        this(bundleServiceAccessorProvider, clazz.getName());
    }

    @Override
    public <TService, TServiceOutcome, TServiceOutcomeValue, TRetVal> TRetVal forServiceAccessor(final ServiceOutcomeHandlerAction<TService, TServiceOutcome, TServiceOutcomeValue, TRetVal> action) throws AgileNotAvailableException, AgileServiceOutcomeException {
        try {
            BundleServiceAccessor bundleServiceAccessor = this.bundleServiceAccessorProvider.createServiceAccessor(this.serviceName);
            return (TRetVal)bundleServiceAccessor.perform(new ServiceCallback<TService, TRetVal>(){

                @Override
                public TRetVal perform(TService service) throws Exception {
                    Object serviceOutcome = action.getServiceOutcome(service);
                    ServiceOutcome serviceOutcomeCasted = (ServiceOutcome)serviceOutcome;
                    if (BundleServiceServiceOutcomeHandler.this.hasErrors(serviceOutcomeCasted)) {
                        return action.handleErrors(serviceOutcome);
                    }
                    Object serviceOutcomeValue = serviceOutcomeCasted.getValue();
                    return action.getResult(serviceOutcomeValue);
                }
            });
        }
        catch (AgileServiceOutcomeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AgileNotAvailableException(e);
        }
    }

    private boolean hasErrors(ServiceOutcome serviceOutcomeCasted) {
        return serviceOutcomeCasted.getErrors() != null && serviceOutcomeCasted.getErrors().hasErrors();
    }
}

